/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementComposite;
import org.eclipse.codewind.ui.internal.prefs.TemplateSourceAuthPage;
import org.eclipse.codewind.ui.internal.prefs.TemplateSourceDetailsPage;
import org.eclipse.codewind.ui.internal.prefs.TemplateSourceURLPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddTemplateSourceWizard
extends Wizard
implements INewWizard {
    private TemplateSourceURLPage urlPage;
    private TemplateSourceAuthPage authPage;
    private TemplateSourceDetailsPage detailsPage;
    private boolean authPageIncluded = false;

    public AddTemplateSourceWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Messages.AddRepoDialogShell);
        this.urlPage = new TemplateSourceURLPage(Messages.AddRepoDialogShell, Messages.AddRepoDialogTitle);
        this.addPage((IWizardPage)this.urlPage);
        this.authPage = new TemplateSourceAuthPage(Messages.AddRepoDialogShell, Messages.AddRepoDialogTitle);
        this.addPage((IWizardPage)this.authPage);
        this.detailsPage = new TemplateSourceDetailsPage(Messages.AddRepoDialogShell, Messages.AddRepoDialogTitle);
        this.addPage((IWizardPage)this.detailsPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.urlPage) {
            URI uri;
            try {
                uri = new URI(this.urlPage.getTemplateSourceUrl());
            }
            catch (URISyntaxException e) {
                IDEUtil.openInfoDialog(Messages.AddRepoDialogInvalidUrlTitle, NLS.bind((String)Messages.AddRepoDialogInvalidUrlError, (Object)e.toString()));
                this.urlPage.setErrorMessage(Messages.AddRepoDialogInvalidUrlMsg);
                return this.urlPage;
            }
            if (this.urlPage.getAuthRequired()) {
                this.authPageIncluded = true;
                this.authPage.updatePage(uri);
                return this.authPage;
            }
            try {
                final Boolean[] requiresAuth = new Boolean[]{Boolean.FALSE};
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        block4: {
                            try {
                                SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.AddRepoDialogUrlPingTask, (Object)uri), (int)-1);
                                HttpUtil.HttpResult result = HttpUtil.get((URI)uri, null);
                                if (result.isGoodResponse) break block4;
                                if (result.responseCode == 401) {
                                    requiresAuth[0] = Boolean.TRUE;
                                    break block4;
                                }
                                String errorMsg = result.error;
                                if (errorMsg == null || errorMsg.trim().isEmpty()) {
                                    errorMsg = NLS.bind((String)Messages.AddRepoDialogUrlPingFailedDefaultMsg, (Object)result.responseCode);
                                }
                                throw new InvocationTargetException(new IOException(errorMsg));
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e, e.toString());
                            }
                        }
                    }
                };
                this.getContainer().run(true, true, runnable);
                if (requiresAuth[0].booleanValue()) {
                    this.authPageIncluded = true;
                    this.authPage.updatePage(uri);
                    return this.authPage;
                }
            }
            catch (Exception e) {
                String msg = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getCause().toString() : e.toString();
                IDEUtil.openInfoDialog(Messages.AddRepoDialogUrlPingFailedTitle, NLS.bind((String)Messages.AddRepoDialogUrlPingFailedError, (Object)this.urlPage.getTemplateSourceUrl(), (Object)msg));
                this.urlPage.setErrorMessage(Messages.AddRepoDialogUrlPingFailedMsg);
                return this.urlPage;
            }
            this.authPageIncluded = false;
            this.detailsPage.updatePage(this.urlPage.getTemplateSourceUrl());
            return this.detailsPage;
        }
        if (page == this.authPage) {
            this.detailsPage.updatePage(this.urlPage.getTemplateSourceUrl());
            return this.detailsPage;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return this.urlPage.canFinish() && (!this.authPageIncluded || this.authPage.canFinish()) && this.detailsPage.canFinish();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        return this.canFinish();
    }

    RepositoryManagementComposite.RepoEntry getRepoEntry() {
        String url = this.urlPage.getTemplateSourceUrl();
        String name = this.detailsPage.getTemplateSourceName();
        String description = this.detailsPage.getTemplateSourceDescription();
        if (!(name == null || name.isEmpty() || description == null || description.isEmpty() || url == null || url.isEmpty())) {
            return new RepositoryManagementComposite.RepoEntry(url, this.authPage.getUsername(), this.authPage.getPassword(), this.authPage.getToken(), name, description);
        }
        return null;
    }
}

