/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.json.JSONObject;

public class TemplateSourceDetailsPage
extends WizardPage {
    public static final String DETAILS_FILE_NAME = "templates.json";
    public static final String NAME_KEY = "name";
    public static final String DESCRIPTION_KEY = "description";
    private String url;
    private Text nameText;
    private Text descriptionText;
    private String nameValue;
    private String descriptionValue;
    private Button resetButton;
    private ProgressMonitorPart progressMon;

    protected TemplateSourceDetailsPage(String shellTitle, String pageTitle) {
        super(shellTitle);
        this.setTitle(pageTitle);
        this.setDescription(Messages.AddRepoDetailsPageMessage);
    }

    protected TemplateSourceDetailsPage(String shellTitle, String pageTitle, String name, String description) {
        this(shellTitle, pageTitle);
        this.nameValue = name;
        this.descriptionValue = description;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(Messages.AddRepoDialogNameLabel);
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        label = new Label(composite, 0);
        label.setText(Messages.AddRepoDialogDescriptionLabel);
        label.setLayoutData((Object)new GridData(1, 2, false, false));
        this.descriptionText = new Text(composite, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.resetButton = new Button(composite, 8);
        this.resetButton.setText(Messages.AddRepoDialogResetButtonLabel);
        this.resetButton.setToolTipText(Messages.AddRepoDialogResetButtonTooltip);
        this.resetButton.setLayoutData((Object)new GridData(3, 4, false, false, 2, 1));
        this.progressMon = new ProgressMonitorPart(parent, (Layout)layout, true);
        this.progressMon.setLayoutData((Object)new GridData(768));
        this.progressMon.setVisible(false);
        this.nameText.addModifyListener(event -> {
            this.validate(false);
            if (this.resetButton.getVisible()) {
                this.resetButton.setEnabled(true);
            }
        });
        this.descriptionText.addModifyListener(event -> {
            this.validate(false);
            if (this.resetButton.getVisible()) {
                this.resetButton.setEnabled(true);
            }
        });
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    TemplateSourceDetailsPage.this.getContainer().run(true, true, TemplateSourceDetailsPage.this.getDetailsRunnable(TemplateSourceDetailsPage.this.url));
                    TemplateSourceDetailsPage.this.resetButton.setEnabled(false);
                }
                catch (Exception e) {
                    Logger.logError((String)"An error occurred trying to get the template source details", (Throwable)e);
                }
            }
        });
        this.resetButton.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, CodewindUIPlugin.MAIN_CONTEXTID);
        if (this.nameValue != null) {
            this.nameText.setText(this.nameValue);
        }
        if (this.descriptionValue != null) {
            this.descriptionText.setText(this.descriptionValue);
        }
        this.setControl((Control)composite);
    }

    public void updatePage(String url) {
        this.url = url;
        try {
            this.getContainer().run(true, true, this.getDetailsRunnable(url));
            this.validate(true);
            this.resetButton.setVisible(this.nameValue != null);
            this.resetButton.setEnabled(false);
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred trying to get the template source details", (Throwable)e);
        }
    }

    private IRunnableWithProgress getDetailsRunnable(final String url) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    monitor.beginTask(Messages.AddRepoDialogAutoFillTaskLabel, -1);
                    URL repoUrl = new URL(url);
                    String path = repoUrl.getPath();
                    path = path.substring(0, path.lastIndexOf("/") + 1) + TemplateSourceDetailsPage.DETAILS_FILE_NAME;
                    URL detailsUrl = new URL(repoUrl.getProtocol(), repoUrl.getHost(), path);
                    HttpUtil.HttpResult result = HttpUtil.get((URI)detailsUrl.toURI());
                    if (result.isGoodResponse && result.response != null && !result.response.isEmpty()) {
                        JSONObject jsonObj = new JSONObject(result.response);
                        String name = jsonObj.has(TemplateSourceDetailsPage.NAME_KEY) ? jsonObj.getString(TemplateSourceDetailsPage.NAME_KEY) : null;
                        String description = jsonObj.has(TemplateSourceDetailsPage.DESCRIPTION_KEY) ? jsonObj.getString(TemplateSourceDetailsPage.DESCRIPTION_KEY) : null;
                        Display.getDefault().syncExec(() -> {
                            if (name == null || name.isEmpty()) {
                                Logger.logError((String)("Found the template source information but the name is null or empty: " + detailsUrl));
                                TemplateSourceDetailsPage.this.setErrorMessage(Messages.AddRepoDialogAutoFillNotAvailableMsg);
                            } else {
                                TemplateSourceDetailsPage.this.nameText.setText(name);
                                TemplateSourceDetailsPage.this.descriptionText.setText(description == null ? "" : description);
                            }
                        });
                    } else {
                        Logger.log((String)("Got error code " + result.error + " trying to retrieve the template source details for url: " + detailsUrl + ", and error: " + result.error));
                        TemplateSourceDetailsPage.this.setErrorMessage(Messages.AddRepoDialogAutoFillNotAvailableMsg);
                    }
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred trying to retrieve the template source details for URL: " + url), (Throwable)e);
                    TemplateSourceDetailsPage.this.setErrorMessage(Messages.AddRepoDialogAutoFillNotAvailableMsg);
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.nameText.setFocus();
        }
    }

    private void validate(boolean init) {
        String errorMsg = null;
        this.nameValue = IDEUtil.getTextValue(this.nameText);
        this.descriptionValue = IDEUtil.getTextValue(this.descriptionText);
        if (this.nameValue == null) {
            errorMsg = Messages.AddRepoDialogNoName;
        } else if (this.descriptionValue == null) {
            errorMsg = Messages.AddRepoDialogNoDescription;
        }
        if (init) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errorMsg);
        }
        this.getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    boolean isActivePage() {
        return this.isCurrentPage();
    }

    boolean canFinish() {
        return this.nameValue != null && this.descriptionValue != null;
    }

    String getTemplateSourceName() {
        return this.nameValue;
    }

    String getTemplateSourceDescription() {
        return this.descriptionValue;
    }
}

