/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.Filewatcher;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;
import org.eclipse.codewind.filewatchers.core.PathUtils;
import org.eclipse.codewind.filewatchers.core.WatchEventEntry;
import org.eclipse.codewind.filewatchers.core.internal.FileChangeEventBatchUtil;

public class IndividualFileWatchService {
    private static final FWLogger log = FWLogger.getInstance();
    private final Map<String, Map<String, PollEntry>> filesToWatchMap_synch = new HashMap<String, Map<String, PollEntry>>();
    private final IndivFileWatchThread thread = new IndivFileWatchThread();
    private final AtomicBoolean disposed = new AtomicBoolean(false);
    private final Filewatcher parent;

    public IndividualFileWatchService(Filewatcher parent) {
        this.parent = parent;
        this.thread.setName(IndivFileWatchThread.class.getSimpleName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilesToWatch(String projectId, List<String> pathsFromPtw) {
        if (this.disposed.get()) {
            return;
        }
        List paths = pathsFromPtw.stream().map(e -> PathUtils.convertAbsoluteUnixStyleNormalizedPathToLocalFile(e)).map(e -> Paths.get(e, new String[0])).collect(Collectors.toList());
        paths = paths.stream().filter(e -> {
            boolean isDirectory;
            boolean bl = isDirectory = Files.exists(e, new LinkOption[0]) && Files.isDirectory(e, new LinkOption[0]);
            if (isDirectory) {
                log.logError("Project '" + projectId + "' was asked to watch a directory, which is not supported: " + e);
            }
            return !isDirectory;
        }).collect(Collectors.toList());
        Map<String, Map<String, PollEntry>> map = this.filesToWatchMap_synch;
        synchronized (map) {
            if (paths.size() == 0) {
                this.filesToWatchMap_synch.remove(projectId);
                this.filesToWatchMap_synch.notify();
                return;
            }
            boolean mapUpdated = false;
            Map<String, PollEntry> currProjectState = this.filesToWatchMap_synch.get(projectId);
            if (currProjectState == null) {
                HashMap newFiles = new HashMap();
                paths.stream().map(e -> new PollEntry(PollEntry.Status.RECENTLY_ADDED, (Path)e, null)).forEach(e -> {
                    log.logInfo("Files to watch - recently added for new project: " + e.absolutePath + "");
                    newFiles.put(e.absolutePath.toString(), e);
                });
                mapUpdated = true;
                this.filesToWatchMap_synch.put(projectId, newFiles);
            } else {
                for (Path paramPath : paths) {
                    String paramPathString = paramPath.toString();
                    PollEntry pe = currProjectState.get(paramPathString);
                    if (pe != null) continue;
                    log.logInfo("Files to watch - recently added for existing project: " + paramPath);
                    currProjectState.put(paramPathString, new PollEntry(PollEntry.Status.RECENTLY_ADDED, paramPath, null));
                    mapUpdated = true;
                }
                HashSet pathsInParam = new HashSet(paths.stream().map(e -> e.toString()).collect(Collectors.toList()));
                Iterator<Map.Entry<String, PollEntry>> it = currProjectState.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, PollEntry> currProjStateEntry = it.next();
                    String pathInCurrentState = currProjStateEntry.getKey();
                    if (pathsInParam.contains(pathInCurrentState)) continue;
                    it.remove();
                    log.logInfo("Files to watch - removing from watch list: " + pathInCurrentState + "");
                    mapUpdated = true;
                }
                if (currProjectState.isEmpty()) {
                    this.filesToWatchMap_synch.remove(projectId);
                }
            }
            if (mapUpdated) {
                this.filesToWatchMap_synch.notify();
            }
        }
    }

    public void dispose() {
        if (this.disposed.get()) {
            return;
        }
        this.disposed.set(true);
        FilewatcherUtils.newThread(() -> {
            Map<String, Map<String, PollEntry>> map = this.filesToWatchMap_synch;
            synchronized (map) {
                this.filesToWatchMap_synch.clear();
                this.filesToWatchMap_synch.notify();
            }
        });
    }

    private static class PollEntry {
        Status lastObservedStatus;
        final Path absolutePath;
        Long lastModifiedDate;

        public PollEntry(Status lastObservedStatus, Path absolutePath, Long lastModifiedDate) {
            this.lastObservedStatus = lastObservedStatus;
            this.absolutePath = absolutePath;
            this.lastModifiedDate = lastModifiedDate;
        }

        static enum Status {
            RECENTLY_ADDED,
            EXISTS,
            DOES_NOT_EXIST;

        }
    }

    private class IndivFileWatchThread
    extends Thread {
        private IndivFileWatchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!IndividualFileWatchService.this.disposed.get()) {
                try {
                    this.innerRun();
                }
                catch (Throwable t) {
                    log.logError("Unexpected error thrown in polling thread, ignoring.", t);
                }
                Map map = IndividualFileWatchService.this.filesToWatchMap_synch;
                synchronized (map) {
                    try {
                        IndividualFileWatchService.this.filesToWatchMap_synch.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void innerRun() {
            HashMap<String, Set> fileChangesDetected = new HashMap<String, Set>();
            HashMap<String, List> localMap = new HashMap<String, List>();
            Map map = IndividualFileWatchService.this.filesToWatchMap_synch;
            synchronized (map) {
                IndividualFileWatchService.this.filesToWatchMap_synch.forEach((projectId, watchFileState) -> localMap.put((String)projectId, new ArrayList(watchFileState.values())));
            }
            localMap.forEach((projectId, filesToWatch) -> {
                for (PollEntry fileToWatch : filesToWatch) {
                    boolean fileExists = Files.exists(fileToWatch.absolutePath, new LinkOption[0]);
                    PollEntry.Status newStatus = fileExists ? PollEntry.Status.EXISTS : PollEntry.Status.DOES_NOT_EXIST;
                    Long fileModifiedTime = null;
                    try {
                        if (fileExists) {
                            fileModifiedTime = Files.getLastModifiedTime(fileToWatch.absolutePath, new LinkOption[0]).toMillis();
                        }
                    }
                    catch (IOException e2) {
                        log.logError("Unexpected error on retrieving last modified time for '" + fileToWatch.absolutePath + "', ignoring.", e2);
                    }
                    if (fileToWatch.lastObservedStatus != PollEntry.Status.RECENTLY_ADDED) {
                        if (fileToWatch.lastObservedStatus != newStatus) {
                            WatchEventEntry.EventType type;
                            if (fileExists) {
                                log.logInfo("Watched file now exists: " + fileToWatch.absolutePath);
                                type = WatchEventEntry.EventType.CREATE;
                            } else {
                                log.logInfo("Watched file has been deleted: " + fileToWatch.absolutePath);
                                type = WatchEventEntry.EventType.DELETE;
                            }
                            Set changedFiles = fileChangesDetected.computeIfAbsent((String)projectId, e -> new HashSet());
                            changedFiles.add(new FileChangeEventBatchUtil.ChangedFileEntry(fileToWatch.absolutePath.toString(), false, type, System.currentTimeMillis()));
                        }
                        if (fileModifiedTime != null && fileToWatch.lastModifiedDate != null && !fileModifiedTime.equals(fileToWatch.lastModifiedDate)) {
                            log.logInfo("Watched file change detected: " + fileToWatch.absolutePath + " " + fileModifiedTime + " " + fileToWatch.lastModifiedDate);
                            Set changedFiles = fileChangesDetected.computeIfAbsent((String)projectId, e -> new HashSet());
                            changedFiles.add(new FileChangeEventBatchUtil.ChangedFileEntry(fileToWatch.absolutePath.toString(), false, WatchEventEntry.EventType.MODIFY, System.currentTimeMillis()));
                        }
                    }
                    fileToWatch.lastObservedStatus = newStatus;
                    fileToWatch.lastModifiedDate = fileModifiedTime;
                }
            });
            fileChangesDetected.forEach((projectId, paths) -> {
                if (paths.size() == 0) {
                    return;
                }
                IndividualFileWatchService.this.parent.internal_receiveIndividualChangesFileList((String)projectId, (Collection<FileChangeEventBatchUtil.ChangedFileEntry>)paths);
            });
        }
    }
}

