/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.cli.UpgradeResult;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.BindProjectWizard;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindProjectWizard;
import org.eclipse.codewind.ui.internal.wizards.WizardLauncher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindInstall {
    public static boolean ENABLE_STOP_APPS_OPTION = false;
    private static final String CODEWIND_WORKSPACE = "codewind-workspace";

    public static void codewindInstallerDialog() {
        CodewindInstall.codewindInstallerDialog(CodewindInstall.getNewProjectPrompt());
    }

    public static void codewindInstallerDialog(IProject project) {
        CodewindInstall.codewindInstallerDialog(CodewindInstall.addExistingProjectPrompt(project));
    }

    private static void codewindInstallerDialog(Runnable prompt) {
        InstallStatus status = CodewindManager.getManager().getInstallStatus();
        Shell shell = Display.getDefault().getActiveShell();
        if (status.hasInstalledVersions()) {
            if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)Messages.UpgradeCodewindDialogMessage)) {
                CodewindInstall.updateCodewind(InstallUtil.getVersion(), true, prompt);
            }
        } else if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)Messages.InstallCodewindDialogMessage)) {
            CodewindInstall.installCodewind(InstallUtil.getVersion(), prompt);
        }
    }

    public static void installerActiveDialog(CodewindManager.InstallerStatus status) {
        if (status == null) {
            Logger.logError((String)"The installerActiveDialog method is invoked but the installer status is null");
            return;
        }
        String msg = null;
        switch (status) {
            case INSTALLING: 
            case STARTING: {
                msg = Messages.InstallCodewindInstallingMessage;
                break;
            }
            case UNINSTALLING: 
            case STOPPING: {
                msg = Messages.InstallCodewindUninstallingMessage;
                break;
            }
            default: {
                Logger.logError((String)("The installerActiveDialog method is invoked but the installer status is not recognized: " + status));
                return;
            }
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.InstallCodewindDialogTitle, (String)msg);
    }

    public static void installCodewind(final String version, final Runnable prompt) {
        try {
            Job job = new Job(Messages.InstallCodewindJobLabel){

                protected IStatus run(IProgressMonitor progressMon) {
                    try {
                        ProcessHelper.ProcessResult result;
                        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progressMon, (int)100);
                        mon.setTaskName(Messages.InstallingCodewindTask);
                        try {
                            result = InstallUtil.installCodewind((String)version, (IProgressMonitor)mon.split(95));
                            if (mon.isCanceled()) {
                                CodewindInstall.removeCodewind(version);
                                return Status.CANCEL_STATUS;
                            }
                            if (result.getExitValue() != 0) {
                                return CodewindInstall.getErrorStatus(result, Messages.CodewindInstallFail);
                            }
                        }
                        catch (TimeoutException e) {
                            return CodewindInstall.getErrorStatus(Messages.CodewindInstallTimeout, e);
                        }
                        mon.setTaskName(Messages.StartingCodewindJobLabel);
                        try {
                            result = InstallUtil.startCodewind((String)version, (IProgressMonitor)mon.split(5));
                            if (mon.isCanceled()) {
                                CodewindInstall.removeCodewind(version);
                                return Status.CANCEL_STATUS;
                            }
                            if (result.getExitValue() != 0) {
                                return CodewindInstall.getErrorStatus(result, Messages.CodewindStartFail);
                            }
                        }
                        catch (TimeoutException e) {
                            return CodewindInstall.getErrorStatus(Messages.CodewindStartTimeout, e);
                        }
                        if (prompt != null) {
                            Display.getDefault().asyncExec(prompt);
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindInstallError, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred installing Codewind: ", (Throwable)e);
        }
    }

    public static void startCodewind(final String version, final Runnable prompt) {
        try {
            Job job = new Job(Messages.StartingCodewindJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ProcessHelper.ProcessResult result = InstallUtil.startCodewind((String)version, (IProgressMonitor)monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, Messages.CodewindStartFail);
                        }
                        if (prompt != null) {
                            Display.getDefault().asyncExec(prompt);
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindStartError, e);
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindStartTimeout, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred starting Codewind: ", (Throwable)e);
        }
    }

    public static void stopCodewind() {
        try {
            Job job = new Job(Messages.StoppingCodewindJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        boolean stopAll = CodewindInstall.getStopAll(monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ProcessHelper.ProcessResult result = InstallUtil.stopCodewind((boolean)stopAll, (IProgressMonitor)monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, Messages.CodewindStopFail);
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindStopError, e);
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindStopTimeout, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred stopping Codewind: ", (Throwable)e);
        }
    }

    public static Runnable getNewProjectPrompt() {
        return new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)Messages.InstallCodewindNewProjectMessage)) {
                    CodewindConnection connection = CodewindConnectionManager.getLocalConnection();
                    if (connection != null && connection.isConnected()) {
                        NewCodewindProjectWizard wizard = new NewCodewindProjectWizard(connection);
                        WizardLauncher.launchWizardWithoutSelection(wizard);
                    } else {
                        Logger.logError((String)"Codewind did not install or start properly in order to create a new project.");
                    }
                }
            }
        };
    }

    public static Runnable addExistingProjectPrompt(final IProject project) {
        return new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)NLS.bind((String)Messages.InstallCodewindAddProjectMessage, (Object)project.getName()))) {
                    CodewindConnection connection = CodewindConnectionManager.getLocalConnection();
                    if (connection != null && connection.isConnected()) {
                        BindProjectWizard wizard = new BindProjectWizard(connection, project);
                        WizardLauncher.launchWizardWithoutSelection(wizard);
                    } else {
                        Logger.logError((String)("Codewind not installed or has unknown status when trying to bind project: " + project.getName()));
                    }
                }
            }
        };
    }

    public static void updateCodewind(final String version, final boolean removeOldVersions, final Runnable prompt) {
        try {
            Job job = new Job(Messages.UpdatingCodewindJobLabel){

                protected IStatus run(IProgressMonitor progressMon) {
                    IStatus upgradeError = null;
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)progressMon, (int)250);
                    try {
                        block39: {
                            ProcessHelper.ProcessResult result;
                            InstallStatus status = CodewindManager.getManager().getInstallStatus();
                            if (status.hasStartedVersions()) {
                                mon.setTaskName(Messages.StoppingCodewindJobLabel);
                                try {
                                    result = InstallUtil.stopCodewind((boolean)true, (IProgressMonitor)mon.split(80));
                                    if (mon.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    if (result.getExitValue() != 0) {
                                        return CodewindInstall.getErrorStatus(result, Messages.CodewindStopFail);
                                    }
                                }
                                catch (TimeoutException e) {
                                    return CodewindInstall.getErrorStatus(Messages.CodewindStopTimeout, e);
                                }
                            }
                            mon.setWorkRemaining(170);
                            if (removeOldVersions) {
                                List oldVersions = status.getInstalledVersions();
                                int ticks = 20 / oldVersions.size();
                                for (String oldVersion : oldVersions) {
                                    mon.setTaskName(NLS.bind((String)Messages.UninstallingCodewindVersionTask, (Object)oldVersion));
                                    try {
                                        ProcessHelper.ProcessResult result2 = InstallUtil.removeCodewind((String)oldVersion, (IProgressMonitor)mon.split(ticks));
                                        if (mon.isCanceled()) {
                                            return Status.CANCEL_STATUS;
                                        }
                                        if (result2.getExitValue() != 0) {
                                            return CodewindInstall.getErrorStatus(result2, Messages.CodewindUninstallFail);
                                        }
                                        CLIUtil.removeCWCTL((String)oldVersion);
                                    }
                                    catch (TimeoutException e) {
                                        return CodewindInstall.getErrorStatus(Messages.CodewindUninstallTimeout, e);
                                    }
                                }
                            }
                            mon.setWorkRemaining(150);
                            mon.setTaskName(Messages.InstallingCodewindTask);
                            try {
                                result = InstallUtil.installCodewind((String)version, (IProgressMonitor)mon.split(95));
                                if (mon.isCanceled()) {
                                    CodewindInstall.removeCodewind(version);
                                    return Status.CANCEL_STATUS;
                                }
                                if (result.getExitValue() != 0) {
                                    return CodewindInstall.getErrorStatus(result, Messages.CodewindInstallFail);
                                }
                            }
                            catch (TimeoutException e) {
                                return CodewindInstall.getErrorStatus(Messages.CodewindInstallTimeout, e);
                            }
                            mon.setTaskName(Messages.StartingCodewindJobLabel);
                            try {
                                result = InstallUtil.startCodewind((String)version, (IProgressMonitor)mon.split(5));
                                if (mon.isCanceled()) {
                                    CodewindInstall.removeCodewind(version);
                                    return Status.CANCEL_STATUS;
                                }
                                if (result.getExitValue() != 0) {
                                    return CodewindInstall.getErrorStatus(result, Messages.CodewindStartFail);
                                }
                            }
                            catch (TimeoutException e) {
                                return CodewindInstall.getErrorStatus(Messages.CodewindStartTimeout, e);
                            }
                            if (status.requiresWSUpgrade()) {
                                String path = null;
                                if (CoreUtil.isWindows()) {
                                    path = "C:/codewind-workspace";
                                } else {
                                    path = System.getProperty("user.home");
                                    if (path != null && !path.isEmpty()) {
                                        if (!path.endsWith("/")) {
                                            path = path + "/";
                                        }
                                        path = path + CodewindInstall.CODEWIND_WORKSPACE;
                                    } else {
                                        Logger.logError((String)"Failed to get the user home directory for upgrading the workspace");
                                    }
                                }
                                if (path != null && !path.isEmpty()) {
                                    File file = new File(path);
                                    if (file.exists() && file.isDirectory()) {
                                        mon.setTaskName(Messages.UpgradeWorkspaceJobLabel);
                                        try {
                                            ProcessHelper.ProcessResult result3 = InstallUtil.upgradeWorkspace((String)file.getAbsolutePath(), (IProgressMonitor)mon.split(50));
                                            if (mon.isCanceled()) {
                                                return Status.CANCEL_STATUS;
                                            }
                                            if (result3.getExitValue() != 0) {
                                                upgradeError = CodewindInstall.getErrorStatus(result3, Messages.WorkspaceUpgradeError);
                                                break block39;
                                            }
                                            try {
                                                String formattedResult = new UpgradeResult(new JSONObject(result3.getOutput())).getFormattedResult();
                                                if (formattedResult != null && !formattedResult.isEmpty()) {
                                                    Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)NLS.bind((String)Messages.WorkspaceUpgradeTitle, (Object)file.getAbsolutePath()), (String)formattedResult));
                                                }
                                            }
                                            catch (JSONException e) {
                                                Logger.logError((String)("The result from the upgrade workspace command is not valid: " + result3.getOutput()), (Throwable)e);
                                                upgradeError = CodewindInstall.getErrorStatus(result3, Messages.WorkspaceUpgradeError);
                                            }
                                        }
                                        catch (TimeoutException e) {
                                            upgradeError = CodewindInstall.getErrorStatus(Messages.WorkspaceUpgradeError, e);
                                        }
                                    } else {
                                        Logger.log((String)("The codewind workspace does not exist so nothing to upgrade: " + path));
                                    }
                                }
                            }
                        }
                        if (prompt != null) {
                            Display.getDefault().asyncExec(prompt);
                        }
                    }
                    catch (Exception e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindUpdateError, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    if (upgradeError != null) {
                        return upgradeError;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred updating Codewind images: ", (Throwable)e);
        }
    }

    public static void removeCodewind(final String version) {
        try {
            Job job = new Job(Messages.RemovingCodewindJobLabel){

                protected IStatus run(IProgressMonitor progressMon) {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)progressMon, (int)100);
                    try {
                        ProcessHelper.ProcessResult result;
                        InstallStatus status = CodewindManager.getManager().getInstallStatus();
                        if (status.isStarted()) {
                            mon.setTaskName(Messages.StoppingCodewindJobLabel);
                            try {
                                result = InstallUtil.stopCodewind((boolean)true, (IProgressMonitor)mon.split(80));
                                if (mon.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                if (result.getExitValue() != 0) {
                                    return CodewindInstall.getErrorStatus(result, Messages.CodewindStopFail);
                                }
                            }
                            catch (TimeoutException e) {
                                return CodewindInstall.getErrorStatus(Messages.CodewindStopTimeout, e);
                            }
                        }
                        if (mon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        mon.setTaskName(Messages.UninstallingCodewindTask);
                        mon.setWorkRemaining(20);
                        result = InstallUtil.removeCodewind((String)version, (IProgressMonitor)mon.split(20));
                        if (mon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, Messages.CodewindUninstallFail);
                        }
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindUninstallTimeout, e);
                    }
                    catch (Exception e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindUninstallError, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred removing Codewind images: ", (Throwable)e);
        }
    }

    private static IStatus getErrorStatus(ProcessHelper.ProcessResult result, String msg) {
        String errorText;
        Logger.logError((String)("Installer failed with return code: " + result.getExitValue() + ", output: " + result.getOutput() + ", error: " + result.getError()));
        String string = errorText = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
        if (errorText == null || errorText.trim().isEmpty()) {
            errorText = NLS.bind((String)Messages.InstallCodewindFailNoMessage, (Object)result.getExitValue());
        }
        return CodewindInstall.getErrorStatus(NLS.bind((String)msg, (Object)errorText), null);
    }

    private static IStatus getErrorStatus(String msg, Throwable t) {
        Logger.logError((String)msg, (Throwable)t);
        ViewHelper.refreshCodewindExplorerView(null);
        return new Status(4, "org.eclipse.codewind.ui", msg, t);
    }

    private static boolean getStopAll(final IProgressMonitor monitor) {
        if (!ENABLE_STOP_APPS_OPTION) {
            return true;
        }
        final IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
        if ("stopAppContainersPrompt".contentEquals(prefs.getString("stopAppContainers"))) {
            if (!CodewindManager.getManager().hasActiveApplications()) {
                return false;
            }
            final boolean[] stopApps = new boolean[]{false};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle stopAppsQuestion = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.StopAllDialog_Title, (String)Messages.StopAllDialog_Message, (String)Messages.StopAllDialog_ToggleMessage, (boolean)false, null, null);
                    switch (stopAppsQuestion.getReturnCode()) {
                        case 2: {
                            stopApps[0] = true;
                            break;
                        }
                        case 1: {
                            monitor.setCanceled(true);
                            break;
                        }
                    }
                    if (!monitor.isCanceled() && stopAppsQuestion.getToggleState()) {
                        prefs.setValue("stopAppContainers", stopApps[0] ? "stopAppContainersAlways" : "stopAppContainersNever");
                    }
                }
            });
            return stopApps[0];
        }
        return "stopAppContainersAlways".contentEquals(prefs.getString("stopAppContainers"));
    }
}

