/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.AddTemplateSourceAuthPage;
import org.eclipse.codewind.ui.internal.prefs.AddTemplateSourceDetailsPage;
import org.eclipse.codewind.ui.internal.prefs.AddTemplateSourceURLPage;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementComposite;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddTemplateSourceWizard
extends Wizard
implements INewWizard {
    private AddTemplateSourceURLPage urlPage;
    private AddTemplateSourceAuthPage authPage;
    private AddTemplateSourceDetailsPage detailsPage;

    public AddTemplateSourceWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Messages.AddRepoDialogShell);
        this.urlPage = new AddTemplateSourceURLPage();
        this.addPage((IWizardPage)this.urlPage);
        this.authPage = new AddTemplateSourceAuthPage();
        this.addPage((IWizardPage)this.authPage);
        this.detailsPage = new AddTemplateSourceDetailsPage();
        this.addPage((IWizardPage)this.detailsPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.urlPage) {
            return this.authPage;
        }
        if (page == this.authPage) {
            this.detailsPage.updatePage(this.urlPage.getUrl());
            return this.detailsPage;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return this.urlPage.canFinish() && (this.authPage == null || this.authPage.canFinish()) && this.detailsPage.canFinish();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        return this.canFinish();
    }

    public RepositoryManagementComposite.RepoEntry getRepoEntry() {
        String url = this.urlPage.getUrl();
        String name = this.detailsPage.getName();
        String description = this.detailsPage.getDescription();
        if (!(name == null || name.isEmpty() || description == null || description.isEmpty() || url == null || url.isEmpty())) {
            return new RepositoryManagementComposite.RepoEntry(name, description, url);
        }
        return null;
    }
}

