/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.util.Arrays;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddTemplateSourceAuthPage
extends WizardPage {
    private Button logonButton;
    private Button tokenButton;
    private boolean isLogonMethod;
    private Composite logonComposite;
    private Composite tokenComposite;
    private Text usernameText;
    private Text passwordText;
    private Text tokenText;
    private String usernameValue;
    private String passwordValue;
    private String tokenValue;

    protected AddTemplateSourceAuthPage() {
        super(Messages.AddRepoDialogShell);
        this.setTitle(Messages.AddRepoDialogTitle);
        this.setDescription(Messages.AddRepoAuthPageMessage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.logonButton = new Button(composite, 16);
        this.logonButton.setText(Messages.AddRepoDialogLogonAuthButton);
        this.logonButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.logonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddTemplateSourceAuthPage.this.setEnablement(AddTemplateSourceAuthPage.this.logonButton.getSelection());
                AddTemplateSourceAuthPage.this.validate();
            }
        });
        this.logonComposite = this.createSubComposite(composite, 2);
        Label label = new Label(this.logonComposite, 0);
        label.setText(Messages.AddRepoDialogUsernameLabel);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.usernameText = new Text(this.logonComposite, 2048);
        this.usernameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.usernameText.addModifyListener(event -> this.validate());
        label = new Label(this.logonComposite, 0);
        label.setText(Messages.AddRepoDialogPasswordLabel);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.passwordText = new Text(this.logonComposite, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.passwordText.addModifyListener(event -> this.validate());
        this.tokenButton = new Button(composite, 16);
        this.tokenButton.setText(Messages.AddRepoDialogAccessTokenAuthButton);
        this.tokenButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.tokenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddTemplateSourceAuthPage.this.setEnablement(!AddTemplateSourceAuthPage.this.tokenButton.getSelection());
                AddTemplateSourceAuthPage.this.validate();
            }
        });
        this.tokenComposite = this.createSubComposite(composite, 2);
        label = new Label(this.tokenComposite, 0);
        label.setText(Messages.AddRepoDialogAccessTokenLabel);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.tokenText = new Text(this.tokenComposite, 2048);
        this.tokenText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tokenText.addModifyListener(event -> this.validate());
        this.isLogonMethod = true;
        this.logonButton.setSelection(this.isLogonMethod);
        this.setEnablement(this.isLogonMethod);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, CodewindUIPlugin.MAIN_CONTEXTID);
        this.setControl((Control)composite);
    }

    protected Composite createSubComposite(Composite parent, int numColumn) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumn;
        layout.marginHeight = 2;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        return composite;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.logonButton.getSelection()) {
                this.usernameText.setFocus();
            } else {
                this.tokenText.setFocus();
            }
        }
    }

    private void setEnablement(boolean isLogonMethod) {
        Arrays.stream(this.logonComposite.getChildren()).forEach(c -> c.setEnabled(isLogonMethod));
        Arrays.stream(this.tokenComposite.getChildren()).forEach(c -> c.setEnabled(!isLogonMethod));
    }

    private void validate() {
        String errorMsg = null;
        this.isLogonMethod = this.logonButton.getSelection();
        if (this.isLogonMethod) {
            this.usernameValue = IDEUtil.getTextValue(this.usernameText);
            this.passwordValue = IDEUtil.getTextValue(this.passwordText);
            if (this.usernameValue == null) {
                errorMsg = Messages.AddRepoDialogNoUsername;
            } else if (this.passwordValue == null) {
                errorMsg = Messages.AddRepoDialogNoPassword;
            }
        } else {
            this.tokenValue = IDEUtil.getTextValue(this.tokenText);
            if (this.tokenValue == null) {
                errorMsg = Messages.AddRepoDialogNoAccessToken;
            }
        }
        this.setErrorMessage(errorMsg);
        this.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.canFinish();
    }

    public boolean isActivePage() {
        return this.isCurrentPage();
    }

    public boolean canFinish() {
        if (this.isLogonMethod) {
            return this.usernameValue != null && this.passwordValue != null;
        }
        return this.tokenValue != null;
    }

    public boolean isLogonMethod() {
        return this.isLogonMethod;
    }

    public String getUsername() {
        return this.usernameValue;
    }

    public String getPassword() {
        return this.passwordValue;
    }

    public String getToken() {
        return this.tokenValue;
    }
}

