/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.net.URI;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.AddTemplateSourceAuthPage;
import org.eclipse.codewind.ui.internal.prefs.AddTemplateSourceDetailsPage;
import org.eclipse.codewind.ui.internal.prefs.AddTemplateSourceURLPage;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementComposite;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddTemplateSourceWizard
extends Wizard
implements INewWizard {
    private AddTemplateSourceURLPage urlPage;
    private AddTemplateSourceAuthPage authPage;
    private AddTemplateSourceDetailsPage detailsPage;
    private boolean authPageIncluded = false;

    public AddTemplateSourceWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Messages.AddRepoDialogShell);
        this.urlPage = new AddTemplateSourceURLPage();
        this.addPage((IWizardPage)this.urlPage);
        this.authPage = new AddTemplateSourceAuthPage();
        this.addPage((IWizardPage)this.authPage);
        this.detailsPage = new AddTemplateSourceDetailsPage();
        this.addPage((IWizardPage)this.detailsPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.urlPage) {
            String urlStr = this.urlPage.getUrl();
            try {
                URI uri = new URI(urlStr);
                HttpUtil.HttpResult result = HttpUtil.get((URI)uri, null);
                if (!result.isGoodResponse && result.responseCode == 401) {
                    this.authPageIncluded = true;
                    return this.authPage;
                }
            }
            catch (Exception e) {
                Logger.logError((String)("An error occurred trying to ping: " + urlStr), (Throwable)e);
            }
            this.authPageIncluded = false;
            this.detailsPage.updatePage(this.urlPage.getUrl());
            return this.detailsPage;
        }
        if (page == this.authPage) {
            this.detailsPage.updatePage(this.urlPage.getUrl());
            return this.detailsPage;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        return this.urlPage.canFinish() && (!this.authPageIncluded || this.authPage.canFinish()) && this.detailsPage.canFinish();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        return this.canFinish();
    }

    public RepositoryManagementComposite.RepoEntry getRepoEntry() {
        String url = this.urlPage.getUrl();
        String name = this.detailsPage.getName();
        String description = this.detailsPage.getDescription();
        if (!(name == null || name.isEmpty() || description == null || description.isEmpty() || url == null || url.isEmpty())) {
            return new RepositoryManagementComposite.RepoEntry(url, this.authPage.getUsername(), this.authPage.getPassword(), this.authPage.getToken(), name, description);
        }
        return null;
    }
}

