/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.util.List;
import org.eclipse.codewind.core.internal.connection.JSONObjectResult;
import org.json.JSONObject;

public class RepositoryInfo
extends JSONObjectResult {
    public static final String URL_KEY = "url";
    public static final String NAME_KEY = "name";
    public static final String DESCRIPTION_KEY = "description";
    public static final String ENABLED_KEY = "enabled";
    public static final String PROTECTED_KEY = "protected";
    public static final String STYLES_KEY = "projectStyles";
    public static final String AUTHENTICATION_KEY = "authentication";
    public static final String USERNAME_KEY = "username";

    public RepositoryInfo(JSONObject repo) {
        super(repo, "repository");
    }

    public String getURL() {
        return this.getString(URL_KEY);
    }

    public String getName() {
        return this.getString(NAME_KEY);
    }

    public String getDescription() {
        return this.getString(DESCRIPTION_KEY);
    }

    public boolean getEnabled() {
        return this.getBoolean(ENABLED_KEY);
    }

    public boolean isProtected() {
        return this.getBoolean(PROTECTED_KEY);
    }

    public List<String> getStyles() {
        return this.getStringArray(STYLES_KEY);
    }

    public boolean hasAuthentication() {
        return this.hasKey(AUTHENTICATION_KEY);
    }

    public String getUsername() {
        JSONObject obj;
        JSONObject jSONObject = obj = this.hasAuthentication() ? this.getObject(AUTHENTICATION_KEY) : null;
        if (obj != null) {
            JSONObjectResult authObj = new JSONObjectResult(obj, "template source auth");
            return authObj.getString(USERNAME_KEY);
        }
        return null;
    }
}

