/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.launch.CodewindLaunchConfigDelegate;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;

public class KubeUtil {
    private static final String KUBECTL_CMD = "kubectl";
    private static final String KUBECTL_EXE = "kubectl.exe";
    private static final String OC_CMD = "oc";
    private static final String OC_EXE = "oc.exe";
    private static String kubeCommand = null;

    public static String getCommand() {
        if (kubeCommand != null) {
            return kubeCommand;
        }
        boolean isWindows = CoreUtil.isWindows();
        String exec = CoreUtil.getExecutablePath(isWindows ? KUBECTL_EXE : KUBECTL_CMD);
        if (exec == null) {
            exec = CoreUtil.getExecutablePath(isWindows ? OC_EXE : OC_CMD);
        }
        kubeCommand = exec;
        return kubeCommand;
    }

    public static PortForwardInfo startPortForward(CodewindApplication app, int localPort, int port) throws Exception {
        KubeUtil.checkApp(app);
        List<String> commandList = KubeUtil.getPortForwardCommand(app, localPort, port);
        ProcessBuilder builder = new ProcessBuilder(commandList);
        Process process = builder.start();
        return new PortForwardInfo(localPort, port, process);
    }

    public static PortForwardInfo launchPortForward(CodewindApplication app, int localPort, int port) throws Exception {
        KubeUtil.checkApp(app);
        List<String> commandList = KubeUtil.getPortForwardCommand(app, localPort, port);
        String title = NLS.bind((String)Messages.PortForwardTitle, (Object)(localPort + ":" + port));
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.codewind.core.internal.utilityLaunchConfigurationType");
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance((IContainer)null, app.name);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.connectionIdAttr", app.connection.getConid());
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.projectIdAttr", app.projectID);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.titleAttr", title);
        workingCopy.setAttribute("org.eclipse.codewind.core.internal.commandAttr", commandList);
        CodewindLaunchConfigDelegate.setConfigAttributes(workingCopy, app);
        ILaunchConfiguration launchConfig = workingCopy.doSave();
        ILaunch launch = launchConfig.launch("run", (IProgressMonitor)new NullProgressMonitor());
        return new PortForwardInfo(localPort, port, launch);
    }

    private static void checkApp(CodewindApplication app) throws IOException {
        if (app.getPodName() == null || app.getNamespace() == null) {
            String msg = "Trying to run kubectl command for the " + app.name + " project but the pod name or the namespace is null";
            Logger.logError(msg);
            throw new IOException(msg);
        }
    }

    private static List<String> getPortForwardCommand(CodewindApplication app, int localPort, int port) throws Exception {
        String processPath = KubeUtil.getCommand();
        if (processPath == null) {
            Logger.logError("Port forwarding cannot be initiated because neither of the kubectl or oc commands could be found on the path");
            throw new IOException(Messages.ErrorNoKubectlMsg);
        }
        String portMapping = localPort + ":" + port;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(processPath);
        commandList.add("port-forward");
        commandList.add("-n");
        commandList.add(app.getNamespace());
        commandList.add(app.getPodName());
        commandList.add(portMapping);
        return commandList;
    }

    public static class PortForwardInfo {
        public final int localPort;
        public final int remotePort;
        public final Process process;
        public final ILaunch launch;

        public PortForwardInfo(int localPort, int remotePort, Process process) {
            this(localPort, remotePort, process, null);
        }

        public PortForwardInfo(int localPort, int remotePort, ILaunch launch) {
            this(localPort, remotePort, null, launch);
        }

        public void terminate() {
            if (this.process != null && this.process.isAlive()) {
                this.process.destroy();
            }
            if (this.launch != null && !this.launch.isTerminated()) {
                try {
                    this.launch.terminate();
                }
                catch (DebugException e) {
                    Logger.logError("An error occured trying to terminate the port forward launch: " + this.localPort + ":" + this.remotePort, e);
                }
            }
        }

        public void terminateAndRemove() {
            this.terminate();
            if (this.launch != null) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.launch);
            }
        }

        private PortForwardInfo(int localPort, int remotePort, Process process, ILaunch launch) {
            this.localPort = localPort;
            this.remotePort = remotePort;
            this.process = process;
            this.launch = launch;
        }
    }
}

