/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.RemoteConnection;
import org.eclipse.codewind.ui.internal.actions.BindAction;
import org.eclipse.codewind.ui.internal.actions.ConnectDisconnectAction;
import org.eclipse.codewind.ui.internal.actions.DiagnosticsAction;
import org.eclipse.codewind.ui.internal.actions.EditConnectionAction;
import org.eclipse.codewind.ui.internal.actions.LogLevelAction;
import org.eclipse.codewind.ui.internal.actions.ManageRegistriesAction;
import org.eclipse.codewind.ui.internal.actions.ManageReposAction;
import org.eclipse.codewind.ui.internal.actions.NewProjectAction;
import org.eclipse.codewind.ui.internal.actions.OpenTektonDashboardAction;
import org.eclipse.codewind.ui.internal.actions.RemoveConnectionAction;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class RemoteConnectionActionProvider
extends CommonActionProvider {
    private ISelectionProvider selProvider;
    private NewProjectAction newProjectAction;
    private BindAction bindAction;
    private ManageRegistriesAction manageRegistriesAction;
    private ManageReposAction manageReposAction;
    private ConnectDisconnectAction connectDisconnectAction;
    private EditConnectionAction editConnectionAction;
    private RemoveConnectionAction removeConnectionAction;
    private RemoteDoubleClickAction remoteDoubleClickAction;
    private OpenTektonDashboardAction openTektonDashboardAction;
    private LogLevelAction logLevelAction;
    private DiagnosticsAction diagnosticsAction;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.selProvider = aSite.getStructuredViewer();
        this.newProjectAction = new NewProjectAction(this.selProvider);
        this.bindAction = new BindAction(this.selProvider);
        this.manageRegistriesAction = new ManageRegistriesAction(this.selProvider);
        this.manageReposAction = new ManageReposAction(this.selProvider);
        this.connectDisconnectAction = new ConnectDisconnectAction(this.selProvider);
        this.editConnectionAction = new EditConnectionAction(this.selProvider);
        this.removeConnectionAction = new RemoveConnectionAction(this.selProvider);
        this.remoteDoubleClickAction = new RemoteDoubleClickAction(this.selProvider);
        this.openTektonDashboardAction = new OpenTektonDashboardAction(this.selProvider);
        this.logLevelAction = new LogLevelAction(this.selProvider);
        this.diagnosticsAction = new DiagnosticsAction(this.selProvider);
    }

    public void fillContextMenu(IMenuManager menu) {
        this.selProvider.setSelection(this.selProvider.getSelection());
        menu.add((IAction)this.newProjectAction);
        menu.add((IAction)this.bindAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.manageRegistriesAction);
        menu.add((IAction)this.manageReposAction);
        menu.add((IContributionItem)new Separator());
        if (this.openTektonDashboardAction.showAction()) {
            menu.add((IAction)this.openTektonDashboardAction);
            menu.add((IContributionItem)new Separator());
        }
        menu.add((IAction)this.connectDisconnectAction);
        menu.add((IAction)this.editConnectionAction);
        menu.add((IAction)this.removeConnectionAction);
        boolean supportSeparator = false;
        if (this.logLevelAction.showAction()) {
            menu.add((IContributionItem)new Separator());
            supportSeparator = true;
            menu.add((IAction)this.logLevelAction);
        }
        if (this.diagnosticsAction.showAction()) {
            if (!supportSeparator) {
                menu.add((IContributionItem)new Separator());
            }
            menu.add((IAction)this.diagnosticsAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.remoteDoubleClickAction);
    }

    private static class RemoteDoubleClickAction
    extends SelectionProviderAction {
        RemoteConnection connection = null;

        public RemoteDoubleClickAction(ISelectionProvider selectionProvider) {
            super(selectionProvider, "");
            this.selectionChanged(this.getStructuredSelection());
        }

        public void selectionChanged(IStructuredSelection sel) {
            Object obj;
            if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof RemoteConnection) {
                this.connection = (RemoteConnection)obj;
                return;
            }
            this.connection = null;
        }

        public void run() {
            if (this.connection != null) {
                if (!this.connection.isConnected()) {
                    ConnectDisconnectAction.connectRemoteCodewind(this.connection);
                } else {
                    ViewHelper.expandConnection((CodewindConnection)this.connection);
                }
            }
        }
    }
}

