/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.HashMap;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.KubeUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.ui.actions.SelectionProviderAction;

public class ContainerShellAction
extends SelectionProviderAction {
    protected CodewindApplication app;

    public ContainerShellAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.ActionOpenContainerShell);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            this.setEnabled(this.app.isAvailable() && this.checkApp(this.app));
            return;
        }
        this.setEnabled(false);
    }

    private boolean checkApp(CodewindApplication app) {
        if (app.connection.isLocal()) {
            return app.getContainerId() != null;
        }
        return app.getPodName() != null && app.getNamespace() != null;
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"ContainerShellAction ran but no application was selected");
            return;
        }
        if (!this.checkApp(this.app)) {
            Logger.logError((String)("ContainerShellAction ran but the container id or pod name and namespace for the application is not set: " + this.app.name));
            return;
        }
        if (!IDEUtil.canOpenTerminal()) {
            Logger.logError((String)"The container shell cannot be opened because the required terminal service dependencies are not installed.");
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ActionOpenContainerShellMissingDepsTitle, (String)Messages.ActionOpenContainerShellMissingDepsMsg);
            return;
        }
        String command = "sh -c \"if type bash > /dev/null; then bash; else sh; fi\"";
        String processPath = null;
        String processArgs = null;
        if (this.app.connection.isLocal()) {
            String envPath = CoreUtil.getEnvPath();
            processPath = envPath != null ? envPath + "docker" : "docker";
            processArgs = "exec -it " + this.app.getContainerId() + " " + command;
        } else {
            processPath = KubeUtil.getCommand();
            if (processPath == null) {
                Logger.logError((String)"The container shell cannot be opened because neither of the kubectl or oc commands could be found on the path");
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ActionOpenContainerShellErrorTitle, (String)Messages.ErrorNoKubectlMsg);
                return;
            }
            processArgs = "exec -n " + this.app.getNamespace() + " -it " + this.app.getPodName() + " -- " + command;
        }
        String title = NLS.bind((String)Messages.ContainerShellTitle, (Object)this.app.name, (Object)this.app.connection.getName());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("delegateId", "org.eclipse.tm.terminal.connector.local.launcher.local");
        properties.put("secondaryId", title);
        properties.put("title", title);
        properties.put("process.path", processPath);
        properties.put("process.args", processArgs);
        ITerminalService terminal = TerminalServiceFactory.getService();
        if (terminal == null) {
            Logger.logError((String)"ContainerShellAction ran but the terminal service is null");
            return;
        }
        terminal.openConsole(properties, null);
    }

    public boolean showAction() {
        return this.app != null;
    }
}

