/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.IUpdateHandler;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class CoreUtil {
    private static final String ENV_PATH_PROPERTY = "org.eclipse.codewind.envPath";

    public static void openDialog(boolean isError, String title, String msg) {
        CoreUtil.openDialog(isError ? DialogType.ERROR : DialogType.INFO, title, msg);
    }

    public static void openDialog(final DialogType type, final String title, final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.open((int)type.getValue(), (Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg, (int)0);
            }
        });
    }

    public static void openDialogWithLink(final DialogType type, final String title, final String msg, final String linkLabel, final String linkUrl) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), title, null, msg, type.getValue(), 0, new String[]{IDialogConstants.OK_LABEL}){

                    protected Control createCustomArea(Composite parent) {
                        return CoreUtil.addLinkToDialog(parent, linkLabel, linkUrl);
                    }
                };
                dialog.open();
            }
        });
    }

    public static Control addLinkToDialog(Composite parent, String linkLabel, final String linkUrl) {
        final Link link = new Link(parent, 64);
        link.setText("<a>" + linkLabel + "</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                    IWebBrowser browser = browserSupport.getExternalBrowser();
                    URL url = new URL(linkUrl);
                    browser.openURL(url);
                }
                catch (Exception e) {
                    Logger.logError("An error occurred trying to open an external browser at: " + link, e);
                }
            }
        });
        return link;
    }

    public static boolean openConfirmDialog(final String title, final String msg) {
        final boolean[] result = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = MessageDialog.open((int)5, (Shell)Display.getDefault().getActiveShell(), (String)title, (String)msg, (int)0);
            }
        });
        return result[0];
    }

    public static String readAllFromStream(InputStream stream) {
        Scanner s = new Scanner(stream);
        s.useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        s.close();
        return result;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    public static String getHostPath(String containerPath) {
        String hostPath = containerPath;
        if (CoreUtil.isWindows() && containerPath.startsWith("/")) {
            String device = containerPath.substring(1, 2);
            hostPath = device + ":" + containerPath.substring(2);
        }
        return hostPath;
    }

    public static String getContainerPath(String hostPath) {
        String containerPath = hostPath;
        if (CoreUtil.isWindows() && hostPath.indexOf(58) == 1) {
            containerPath = "/" + hostPath.charAt(0) + hostPath.substring(2);
            containerPath = containerPath.replace("\\", "/");
        }
        return containerPath;
    }

    public static IPath appendPathWithoutDupe(IPath start, String finish) {
        Path finishPath = new Path(finish);
        if (start.lastSegment().equals(finishPath.segment(0))) {
            start = start.removeLastSegments(1);
        }
        return start.append((IPath)finishPath);
    }

    public static List<String> splitPath(IPath path, int length) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentString = new StringBuilder().append('/');
        for (String segment : path.segments()) {
            if (currentString.length() + segment.length() > length) {
                result.add(currentString.toString());
                currentString = new StringBuilder();
            }
            currentString.append(segment).append('/');
        }
        if (currentString.length() > 0) {
            result.add(currentString.toString());
        }
        return result;
    }

    public static String formatString(String[] strArray, String separator) {
        return Arrays.stream(strArray).collect(Collectors.joining(separator));
    }

    public static int parsePort(String portStr) {
        try {
            return Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            Logger.logError(String.format("Couldn't parse port from \"%s\"", portStr), e);
            return -1;
        }
    }

    public static void updateAll() {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.updateAll();
        }
    }

    public static void updateConnection(CodewindConnection connection) {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.updateConnection(connection);
        }
    }

    public static void removeConnection(CodewindConnection conn) {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.removeConnection(conn);
        }
    }

    public static void updateApplication(CodewindApplication app) {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.updateApplication(app);
        }
    }

    public static void removeApplication(CodewindApplication app) {
        IUpdateHandler handler = CodewindCorePlugin.getUpdateHandler();
        if (handler != null) {
            handler.removeApplication(app);
        }
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static boolean isMACOS() {
        String osName = CoreUtil.getOSName();
        return osName != null && osName.toLowerCase().contains("mac");
    }

    public static String getEnvPath() {
        String path = System.getProperty(ENV_PATH_PROPERTY);
        if (path == null || path.trim().isEmpty()) {
            if (CoreUtil.isMACOS()) {
                return "/usr/local/bin/";
            }
            return null;
        }
        path = path.trim();
        if (!(path = path.replace("\\", "/")).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static IPath getCodewindDataPath() {
        if (CoreUtil.isWindows()) {
            return new Path("C:/codewind-data");
        }
        IPath userHome = CoreUtil.getUserHome();
        if (userHome != null) {
            return userHome.append("codewind-data");
        }
        return null;
    }

    public static IPath getUserHome() {
        String homeDir = System.getProperty("user.home");
        if (homeDir != null && !homeDir.isEmpty()) {
            return new Path(homeDir);
        }
        Logger.logError("The user.home system property was null or empty.");
        return null;
    }

    public static IProject getEclipseProject(CodewindApplication app) {
        IContainer[] containers;
        for (IContainer container : containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new File(app.fullLocalPath.toOSString()).toURI())) {
            if (!(container instanceof IProject) || !((IProject)container).isAccessible()) continue;
            return (IProject)container;
        }
        return null;
    }

    public static String getExecutablePath(String name) {
        File file;
        String path = CoreUtil.getEnvPath();
        if (path != null && (file = new File(path, name)).isFile() && file.canExecute()) {
            return file.getAbsolutePath();
        }
        for (String dir : System.getenv("PATH").split(File.pathSeparator)) {
            File file2 = new File(dir, name);
            if (!file2.isFile() || !file2.canExecute()) continue;
            return file2.getAbsolutePath();
        }
        return null;
    }

    public static enum DialogType {
        ERROR(1),
        WARN(4),
        INFO(2);

        private int value;

        private DialogType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

