/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.debug;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.IDebugLauncher;
import org.eclipse.codewind.core.internal.KubeUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.RemoteEclipseApplication;
import org.eclipse.codewind.core.internal.launch.CodewindLaunchConfigDelegate;
import org.eclipse.codewind.core.internal.launch.RemoteLaunchConfigDelegate;
import org.eclipse.codewind.ui.internal.debug.NodeJsBrowserDialog;
import org.eclipse.codewind.ui.internal.debug.WebBrowserSelectionDialog;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.json.JSONArray;
import org.json.JSONObject;

public class NodeJSDebugLauncher
implements IDebugLauncher {
    private static final String NODEJS_LAUNCH_CONFIG_ID = "org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebugAttach";
    private static final String ADDRESS_ATTR = "address";
    private static final String PORT_ATTR = "port";
    private static final String LOCAL_ROOT_ATTR = "localRoot";
    private static final String REMOTE_ROOT_ATTR = "remoteRoot";
    private static final String DEBUG_INFO = "/json/list";
    private static final String DEVTOOLS_URL_FIELD = "devtoolsFrontendUrl";
    private static Optional<ILaunchConfigurationType> launchConfigType = null;

    public IStatus launchDebugger(CodewindEclipseApplication app, IProgressMonitor monitor) {
        IStatus status;
        KubeUtil.PortForwardInfo pfInfo = null;
        if (app instanceof RemoteEclipseApplication && app.getDebugConnectPort() == -1) {
            int port = PlatformUtil.findFreePort();
            if (port <= 0) {
                String msg = "Could not find a free port for port forwarding the debug port for project: " + app.name;
                Logger.logError((String)msg);
                return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.NodeJSDebugPortForwardError, (Object)app.name), (Throwable)new IOException(msg));
            }
            try {
                pfInfo = NodeJSDebugLauncher.useBuiltinDebugger() ? KubeUtil.startPortForward((CodewindApplication)app, (int)port, (int)app.getContainerDebugPort()) : KubeUtil.launchPortForward((CodewindApplication)app, (int)port, (int)app.getContainerDebugPort());
                ((RemoteEclipseApplication)app).setDebugPFInfo(pfInfo);
            }
            catch (Exception e) {
                return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.NodeJSDebugPortForwardError, (Object)app.name), (Throwable)e);
            }
        }
        if ((status = NodeJSDebugLauncher.useBuiltinDebugger() ? this.launchInternalDebugSession(app, pfInfo, monitor) : this.launchBrowserDebugSession((CodewindApplication)app)) == Status.CANCEL_STATUS && pfInfo != null) {
            pfInfo.terminateAndRemove();
        }
        return status;
    }

    private IStatus launchInternalDebugSession(CodewindEclipseApplication app, KubeUtil.PortForwardInfo pfInfo, IProgressMonitor monitor) {
        try {
            ILaunchConfigurationWorkingCopy workingCopy = NodeJSDebugLauncher.getLaunchConfigType().get().newInstance((IContainer)null, app.name);
            workingCopy.setAttribute(ADDRESS_ATTR, app.getDebugConnectHost());
            workingCopy.setAttribute(PORT_ATTR, app.getDebugConnectPort());
            workingCopy.setAttribute(LOCAL_ROOT_ATTR, app.fullLocalPath.toOSString());
            workingCopy.setAttribute(REMOTE_ROOT_ATTR, app.getContainerAppRoot() == null ? "/app" : app.getContainerAppRoot());
            CodewindLaunchConfigDelegate.setConfigAttributes((ILaunchConfigurationWorkingCopy)workingCopy, (CodewindApplication)app);
            ILaunchConfiguration launchConfig = workingCopy.doSave();
            ILaunch launch = launchConfig.launch("debug", monitor);
            if (pfInfo != null && pfInfo.process != null) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put(IProcess.ATTR_PROCESS_TYPE, "codewind.utility");
                String title = NLS.bind((String)Messages.PortForwardTitle, (Object)(pfInfo.localPort + ":" + app.getContainerDebugPort()));
                launch.addProcess((IProcess)new RuntimeProcess(launch, pfInfo.process, title, attributes));
                RemoteLaunchConfigDelegate.addDebugEventListener((ILaunch)launch);
            }
            app.setLaunch(launch);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private IStatus launchBrowserDebugSession(CodewindApplication app) {
        String urlString = null;
        Exception e = null;
        try {
            urlString = this.getDebugURL(app);
        }
        catch (Exception e1) {
            e = e1;
        }
        if (urlString == null) {
            Logger.logError((String)("Failed to get the debug URL for the " + app.name + " application."), (Throwable)e);
            return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.NodeJSDebugURLError, (Object)app.name), (Throwable)e);
        }
        IStatus status = this.openNodeJSDebugger(urlString);
        return status;
    }

    private static Optional<ILaunchConfigurationType> getLaunchConfigType() {
        if (launchConfigType == null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchConfigType = Optional.ofNullable(launchManager.getLaunchConfigurationType(NODEJS_LAUNCH_CONFIG_ID));
        }
        return launchConfigType;
    }

    public static boolean useBuiltinDebugger() {
        return NodeJSDebugLauncher.hasBuiltinDebugger() && CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("useBuiltinNodejsDebug");
    }

    public static boolean hasBuiltinDebugger() {
        return NodeJSDebugLauncher.getLaunchConfigType().isPresent();
    }

    public boolean canAttachDebugger(CodewindEclipseApplication app) {
        if (NodeJSDebugLauncher.useBuiltinDebugger()) {
            ILaunch launch = app.getLaunch();
            IDebugTarget debugTarget = launch == null ? null : launch.getDebugTarget();
            return debugTarget == null || debugTarget.isDisconnected();
        }
        String host = app.getDebugConnectHost();
        int debugPort = app.getDebugConnectPort();
        if (app instanceof RemoteEclipseApplication && debugPort == -1) {
            return true;
        }
        try {
            String url;
            String response;
            JSONArray array;
            JSONObject info;
            URI uri = new URI("http", null, host, debugPort, DEBUG_INFO, null, null);
            HttpUtil.HttpResult result = HttpUtil.get((URI)uri);
            if (result.isGoodResponse && (info = (array = new JSONArray(response = result.response)).getJSONObject(0)).has(DEVTOOLS_URL_FIELD) && (url = info.getString(DEVTOOLS_URL_FIELD)) != null && !url.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.log((String)("Failed to retrieve the debug information for the " + app.name + " app: " + e.getMessage()));
        }
        return false;
    }

    private String getDebugURL(CodewindApplication app) throws Exception {
        IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
        int debugTimeout = prefs.getInt("serverDebugTimeout");
        String host = app.getDebugConnectHost();
        int debugPort = app.getDebugConnectPort();
        URI uri = new URI("http", null, host, debugPort, DEBUG_INFO, null, null);
        Exception e = null;
        HttpUtil.HttpResult result = null;
        for (int i = 0; i <= debugTimeout; ++i) {
            try {
                result = HttpUtil.get((URI)uri);
                if (result.isGoodResponse) {
                    String response = result.response;
                    JSONArray array = new JSONArray(response);
                    JSONObject info = array.getJSONObject(0);
                    String url = info.getString(DEVTOOLS_URL_FIELD);
                    int start = url.indexOf("ws=") + 3;
                    int end = url.indexOf("/", start);
                    String subString = url.substring(start, end);
                    url = url.replace(subString, host + ":" + Integer.toString(debugPort));
                    return url;
                }
            }
            catch (Exception e1) {
                e = e1;
            }
            if (i > debugTimeout) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result != null && !result.isGoodResponse) {
            Logger.logError((String)("Error getting debug information for the " + app.name + " application. Error code: " + result.responseCode + ", error: " + result.error + "."));
        } else {
            Logger.logError((String)("An exception occurred trying to retrieve the debug information for the " + app.name + " application."), (Throwable)e);
        }
        if (e != null) {
            throw e;
        }
        return null;
    }

    private IStatus openNodeJSDebugger(String chromeDevToolsUrl) {
        IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
        String browserName = prefs.getString("nodejsDebugBrowserName");
        if (browserName != null) {
            Logger.log((String)("Using the " + browserName + " browser from the preferences."));
            if (!this.foundValidBrowser(browserName)) {
                browserName = null;
            }
        }
        if (browserName == null) {
            final AtomicInteger returnCode = new AtomicInteger(0);
            final String[] result = new String[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    WebBrowserSelectionDialog browserSelection = new WebBrowserSelectionDialog(Display.getDefault().getActiveShell(), Messages.BrowserSelectionTitle, null, Messages.BrowserSelectionDescription, 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    browserSelection.create();
                    browserSelection.open();
                    returnCode.set(browserSelection.getReturnCode());
                    if (returnCode.get() == 0) {
                        result[0] = browserSelection.getBrowserName();
                        boolean isNodejsDefaultBrowserSet = browserSelection.isNodejsDefaultBrowserSet();
                        if (isNodejsDefaultBrowserSet && browserSelection.getBrowserName() != null) {
                            IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
                            prefs.setValue("nodejsDebugBrowserName", browserSelection.getBrowserName());
                        }
                    }
                }
            });
            if (returnCode.get() == 0) {
                browserName = result[0];
            } else {
                return Status.CANCEL_STATUS;
            }
        }
        return this.openBrowserDialog(chromeDevToolsUrl, browserName);
    }

    private IStatus openBrowserDialog(final String chromeDevToolsUrl, final String browserName) {
        final AtomicInteger returnCode = new AtomicInteger(0);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                NodeJsBrowserDialog nodeDialog = new NodeJsBrowserDialog(Display.getDefault().getActiveShell(), Messages.NodeJSOpenBrowserTitle, null, Messages.NodeJSOpenBrowserDesc, 5, new String[]{IDialogConstants.OK_LABEL}, 0, chromeDevToolsUrl, browserName);
                nodeDialog.open();
                returnCode.set(nodeDialog.getReturnCode());
            }
        });
        if (returnCode.get() != 0) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private boolean foundValidBrowser(String browserName) {
        List browserList;
        BrowserManager bm = BrowserManager.getInstance();
        if (bm != null && (browserList = bm.getWebBrowsers()) != null) {
            int len = browserList.size();
            for (int i = 0; i < len; ++i) {
                String name;
                IBrowserDescriptor tempBrowser = (IBrowserDescriptor)browserList.get(i);
                if (tempBrowser == null || tempBrowser.getLocation() == null || tempBrowser.getLocation().trim().equals("") || (name = tempBrowser.getName()) == null || !name.equalsIgnoreCase(browserName)) continue;
                return true;
            }
        }
        return false;
    }
}

