/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.codewind.core.internal.connection.RepositoryInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.TemplateSourceAuthComposite;
import org.eclipse.codewind.ui.internal.wizards.CompositeContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TemplateSourceAuthDialog
extends TitleAreaDialog
implements CompositeContainer {
    private URI uri;
    private RepositoryInfo repo;
    private TemplateSourceAuthComposite composite;
    private ProgressMonitorPart progressMon;

    public TemplateSourceAuthDialog(Shell parentShell, URI uri, RepositoryInfo repo) {
        super(parentShell);
        this.uri = uri;
        this.repo = repo;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RepoAuthDialogShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.setTitle(Messages.RepoAuthDialogTitle);
        this.setMessage(Messages.RepoAuthDialogMsg);
        Composite content = (Composite)super.createDialogArea(parent);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Text descriptionText = new Text(content, 74);
        descriptionText.setText(NLS.bind((String)Messages.RepoAuthDialogDescription, (Object)this.uri.toString()));
        descriptionText.setLayoutData((Object)new GridData(1, 4, true, false));
        IDEUtil.normalizeBackground((Control)descriptionText, (Control)content);
        String username = this.repo.getUsername();
        this.composite = new TemplateSourceAuthComposite(content, this, !this.repo.hasAuthentication() || username != null, username);
        this.composite.setLayoutData(new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 10;
        layout.marginWidth = 20;
        this.progressMon = new ProgressMonitorPart(parent, (Layout)layout, true);
        this.progressMon.setLayoutData((Object)new GridData(768));
        this.progressMon.setVisible(false);
        this.composite.updatePage(this.uri.toString());
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    @Override
    public void validate() {
        this.setMessage(Messages.RepoAuthDialogMsg);
        this.setErrorMessage(this.composite.validate());
        this.getButton(0).setEnabled(this.composite.canFinish());
    }

    @Override
    public void run(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.progressMon.setVisible(true);
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.progressMon, (Display)this.getShell().getDisplay());
        }
        finally {
            this.progressMon.done();
            this.progressMon.setVisible(false);
        }
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return new Point(650, point.y + 100);
    }

    public boolean isLogonMethod() {
        return this.composite.isLogonMethod();
    }

    public String getUsername() {
        return this.composite.getUsername();
    }

    public String getPassword() {
        return this.composite.getPassword();
    }

    public String getToken() {
        return this.composite.getToken();
    }
}

