/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import java.util.HashSet;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.IUpdateHandler;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.views.ViewHelper;

public class UpdateHandler
implements IUpdateHandler {
    private HashSet<UpdateListener> updateListeners = new HashSet();

    public void updateAll() {
        ViewHelper.refreshCodewindExplorerView(null);
        this.updateListeners(UpdateType.MODIFY, null);
    }

    public void updateConnection(CodewindConnection connection) {
        ViewHelper.refreshCodewindExplorerView(connection);
        ViewHelper.expandConnection(connection);
        this.updateListeners(UpdateType.MODIFY, connection);
    }

    public void updateApplication(CodewindApplication app) {
        ViewHelper.refreshCodewindExplorerView(app);
        ViewHelper.expandConnection(app.connection);
        this.updateListeners(UpdateType.MODIFY, app);
    }

    public void removeConnection(CodewindConnection conn) {
        ViewHelper.refreshCodewindExplorerView(null);
        this.updateListeners(UpdateType.REMOVE, conn);
    }

    public void removeApplication(CodewindApplication app) {
        ViewHelper.refreshCodewindExplorerView(app.connection);
        ViewHelper.expandConnection(app.connection);
        this.updateListeners(UpdateType.REMOVE, app);
        this.updateListeners(UpdateType.MODIFY, app.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListeners(UpdateType type, Object element) {
        HashSet<UpdateListener> hashSet = this.updateListeners;
        synchronized (hashSet) {
            this.updateListeners.stream().forEach(listener -> listener.update(type, element));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateListener(UpdateListener listener) {
        HashSet<UpdateListener> hashSet = this.updateListeners;
        synchronized (hashSet) {
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdateListener(UpdateListener listener) {
        HashSet<UpdateListener> hashSet = this.updateListeners;
        synchronized (hashSet) {
            this.updateListeners.remove(listener);
        }
    }

    public static interface UpdateListener {
        public void update(UpdateType var1, Object var2);
    }

    public static enum UpdateType {
        MODIFY,
        REMOVE;

    }
}

