/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.ProjectUtil;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RestartRunModeAction
extends SelectionProviderAction {
    public static final String ACTION_ID = "org.eclipse.codewind.ui.restartRunModeAction";
    protected CodewindEclipseApplication app;

    public RestartRunModeAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.RestartInRunMode);
        this.setImageDescriptor(CodewindUIPlugin.getImageDescriptor("elcl16/run_exc.png"));
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            if (this.app.isAvailable() && this.app.getProjectCapabilities().canRestart()) {
                this.setEnabled(this.app.getAppStatus() == AppStatus.STARTED || this.app.getAppStatus() == AppStatus.STARTING);
                return;
            }
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"RestartRunModeAction ran but no application was selected");
            return;
        }
        this.app.clearDebugger();
        Job job = new Job(NLS.bind((String)Messages.RestartInRunModeTask, (Object)this.app.name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProjectUtil.restartProject((String)RestartRunModeAction.this.app.name, (String)RestartRunModeAction.this.app.projectID, (String)StartMode.RUN.startMode, (String)RestartRunModeAction.this.app.connection.getConid(), (IProgressMonitor)monitor);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("Error initiating restart for project: " + RestartRunModeAction.this.app.name), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ErrorOnRestartMsg, (Object)RestartRunModeAction.this.app.name), (Throwable)e);
                }
            }
        };
        job.schedule();
    }

    public boolean showAction() {
        return this.app != null && this.app.isAvailable() && this.app.getProjectCapabilities().canRestart();
    }
}

