/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.cli.ProjectUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.connection.ProjectTypeInfo;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.UIConstants;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.actions.ImportProjectAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppOverviewAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RegistryManagementDialog;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.ConnectionSelectionPage;
import org.eclipse.codewind.ui.internal.wizards.ProjectDeployedDialog;
import org.eclipse.codewind.ui.internal.wizards.ProjectSelectionPage;
import org.eclipse.codewind.ui.internal.wizards.ProjectTypeSelectionPage;
import org.eclipse.codewind.ui.internal.wizards.ProjectValidationPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class BindProjectWizard
extends Wizard
implements INewWizard {
    private ConnectionSelectionPage connectionPage;
    private ProjectSelectionPage projectPage;
    private ProjectValidationPage projectValidationPage;
    private ProjectTypeSelectionPage projectTypePage;
    private List<CodewindConnection> connections;
    private CodewindConnection connection;
    private IProject project = null;
    private IPath projectPath = null;

    public BindProjectWizard(CodewindConnection connection) {
        this(connection, null);
    }

    public BindProjectWizard(List<CodewindConnection> connections) {
        this(null, null);
        this.connections = connections;
    }

    public BindProjectWizard(CodewindConnection connection, IProject project) {
        this.connection = connection;
        this.project = project;
        if (project != null) {
            this.projectPath = project.getLocation();
        }
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(CodewindUIPlugin.getImageDescriptor("codewindBanner.png"));
        this.setHelpAvailable(false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Messages.BindProjectWizardTitle);
        if (this.connection == null) {
            if (this.connections == null) {
                this.connections = CodewindConnectionManager.activeConnections();
            }
            if (this.connections.size() == 1) {
                this.connection = this.connections.get(0);
            } else {
                this.connectionPage = new ConnectionSelectionPage(this.connections);
                this.addPage((IWizardPage)this.connectionPage);
            }
        }
        if (this.connection != null && (this.connection.isLocal() && !this.checkInstallStatus() || !this.connection.isLocal() && !this.checkRemoteStatus())) {
            if (this.getContainer() != null) {
                this.getContainer().getShell().close();
            }
            return;
        }
        if (this.projectPath == null) {
            this.projectPage = new ProjectSelectionPage(this.connection);
            this.addPage((IWizardPage)this.projectPage);
        }
        this.projectValidationPage = new ProjectValidationPage(this.connection, this.project);
        this.projectTypePage = new ProjectTypeSelectionPage(this.connection);
        this.addPage((IWizardPage)this.projectValidationPage);
        this.addPage((IWizardPage)this.projectTypePage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.connectionPage != null && this.connectionPage.isActivePage()) {
            this.connection = this.connectionPage.getConnection();
            if (this.connection.isLocal() && !this.checkInstallStatus() || !this.connection.isLocal() && !this.checkRemoteStatus()) {
                if (this.getContainer() != null) {
                    this.getContainer().getShell().close();
                }
                return null;
            }
            this.projectValidationPage.setConnection(this.connection);
            return this.projectValidationPage;
        }
        if (this.projectPage != null && this.projectPage.isActivePage()) {
            this.projectValidationPage.setProject(this.projectPage.getProject(), this.projectPage.getProjectPath());
            return this.projectValidationPage;
        }
        if (this.projectValidationPage.isActivePage()) {
            this.projectTypePage.initPage(this.connection, this.projectValidationPage.getProjectInfo());
            return this.projectTypePage;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.projectPage != null && !this.projectPage.canFinish()) {
            return false;
        }
        if (this.projectValidationPage.isActivePage() && this.projectValidationPage.canFinish()) {
            return true;
        }
        return this.projectTypePage.isActivePage() && this.projectTypePage.canFinish();
    }

    public boolean performCancel() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performFinish() {
        ProjectDeployedDialog.Behaviour selectedBehaviour;
        if (!this.canFinish()) {
            return false;
        }
        if (this.projectPage != null) {
            this.project = this.projectPage.getProject();
            this.projectPath = this.projectPage.getProjectPath();
        }
        final String name = this.project != null ? this.project.getName() : this.projectPath.lastSegment();
        final ArrayList<CodewindApplication> existingDeployments = new ArrayList<CodewindApplication>();
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            CodewindApplication app;
            if (!conn.isConnected() || (app = conn.getAppByLocation(this.projectPath)) == null || !app.isEnabled()) continue;
            existingDeployments.add(app);
        }
        if (!existingDeployments.isEmpty()) {
            ProjectDeployedDialog dialog = new ProjectDeployedDialog(this.getShell(), this.projectPath, this.connection, existingDeployments);
            if (dialog.open() != 0) return false;
            selectedBehaviour = dialog.getSelectedBehaviour();
        } else {
            selectedBehaviour = null;
        }
        final ProjectInfo detectedProjectInfo = this.projectValidationPage.isActivePage() ? this.projectValidationPage.getProjectInfo() : null;
        final ProjectTypeInfo projectTypeInfo = this.projectTypePage.getProjectTypeInfo();
        final String typeId = detectedProjectInfo != null ? detectedProjectInfo.type.getId() : projectTypeInfo.getId();
        Job job = new Job(NLS.bind((String)Messages.BindProjectWizardJobLabel, (Object[])new String[]{this.connection.getName(), name})){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CodewindApplication app2;
                    final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)140);
                    if (!BindProjectWizard.this.connection.isLocal() && ProjectType.isCodewindStyle((String)typeId) && !BindProjectWizard.this.connection.requestHasPushRegistry()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), Messages.NoPushRegistryTitle, null, Messages.NoPushRegistryMessage, 5, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}){

                                    protected Control createCustomArea(Composite parent) {
                                        return CoreUtil.addLinkToDialog((Composite)parent, (String)Messages.ImageRegistryDocLinkLabel, (String)UIConstants.REGISTRY_INFO_URL);
                                    }
                                };
                                if (dialog.open() == 0) {
                                    RegistryManagementDialog.open(BindProjectWizard.this.getShell(), BindProjectWizard.this.connection, (IProgressMonitor)mon.split(40));
                                } else {
                                    mon.setCanceled(true);
                                }
                            }
                        });
                        if (mon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (!BindProjectWizard.this.connection.requestHasPushRegistry()) {
                            return new Status(4, "org.eclipse.codewind.ui", Messages.NoPushRegistryError, null);
                        }
                    }
                    mon.setWorkRemaining(100);
                    if (selectedBehaviour != null) {
                        switch (selectedBehaviour) {
                            case REMOVE: {
                                mon.setTaskName(Messages.BindProjectWizardRemoveTask);
                                for (CodewindApplication app2 : existingDeployments) {
                                    try {
                                        ProjectUtil.removeProject((String)app2.name, (String)app2.projectID, (IProgressMonitor)mon.split(10));
                                    }
                                    catch (Exception e) {
                                        Logger.logError((String)("An error occurred trying to unbind the " + app2.name + " project from connection: " + app2.connection.getBaseURI()));
                                    }
                                    if (!mon.isCanceled()) continue;
                                    return Status.CANCEL_STATUS;
                                }
                                break;
                            }
                            case DISABLE: {
                                mon.setTaskName(Messages.BindProjectWizardDisableTask);
                                mon.split(10 * existingDeployments.size());
                                for (CodewindApplication app2 : existingDeployments) {
                                    try {
                                        app2.connection.requestProjectOpenClose(app2, false);
                                    }
                                    catch (Exception e) {
                                        Logger.logError((String)("An error occurred trying to disable the " + app2.name + " project on connection: " + app2.connection.getBaseURI()));
                                    }
                                    if (mon.isCanceled()) {
                                        return Status.CANCEL_STATUS;
                                    }
                                    mon.worked(10);
                                }
                                break;
                            }
                        }
                    }
                    mon.setWorkRemaining(50);
                    String path = BindProjectWizard.this.projectPath.toFile().getAbsolutePath();
                    if (detectedProjectInfo != null) {
                        ProjectUtil.bindProject((String)name, (String)path, (String)detectedProjectInfo.language.getId(), (String)detectedProjectInfo.type.getId(), (String)BindProjectWizard.this.connection.getConid(), (IProgressMonitor)mon.split(30));
                    } else {
                        ProjectTypeInfo.ProjectSubtypeInfo projectSubtypeInfo = BindProjectWizard.this.projectTypePage.getProjectSubtypeInfo();
                        String language = BindProjectWizard.this.projectTypePage.getLanguage();
                        if (projectSubtypeInfo != null) {
                            ProjectUtil.validateProject((String)name, (String)path, (String)(projectTypeInfo.getId() + ":" + projectSubtypeInfo.id), (String)BindProjectWizard.this.connection.getConid(), (IProgressMonitor)mon.split(10));
                        }
                        mon.setWorkRemaining(40);
                        ProjectUtil.bindProject((String)name, (String)path, (String)language, (String)projectTypeInfo.getId(), (String)BindProjectWizard.this.connection.getConid(), (IProgressMonitor)mon.split(20));
                    }
                    if (mon.isCanceled()) {
                        BindProjectWizard.cleanup(name, BindProjectWizard.this.connection);
                        return Status.CANCEL_STATUS;
                    }
                    mon.split(10);
                    BindProjectWizard.this.connection.refreshApps(null);
                    if (mon.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    mon.split(10);
                    app2 = BindProjectWizard.this.connection.getAppByName(name);
                    if (app2 != null) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (project == null || !project.exists()) {
                            ImportProjectAction.importProject(app2);
                        }
                        if (CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("autoOpenOverviewPage")) {
                            Display.getDefault().asyncExec(() -> OpenAppOverviewAction.openAppOverview(app2));
                        }
                    }
                    mon.done();
                    ViewHelper.openCodewindExplorerView();
                    CodewindUIPlugin.getUpdateHandler().updateConnection(BindProjectWizard.this.connection);
                    return Status.OK_STATUS;
                }
                catch (TimeoutException e) {
                    Logger.logError((String)("A timeout occurred trying to add the " + name + " project to connection: " + BindProjectWizard.this.connection.getName()), (Throwable)e);
                    BindProjectWizard.cleanup(name, BindProjectWizard.this.connection);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.BindProjectWizardTimeout, (Object)BindProjectWizard.this.projectPath.toOSString()), (Throwable)e);
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occured trying to add the project to Codewind: " + BindProjectWizard.this.projectPath.toOSString()), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.BindProjectWizardError, (Object)BindProjectWizard.this.projectPath.toOSString()), (Throwable)e);
                }
            }
        };
        job.schedule();
        return true;
    }

    public static void cleanup(final String projectName, final CodewindConnection connection) {
        Job job = new Job(NLS.bind((String)Messages.ProjectCleanupJobLabel, (Object)projectName)){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
                mon.split(10);
                connection.refreshApps(null);
                CodewindApplication app = connection.getAppByName(projectName);
                if (app != null) {
                    try {
                        ProjectUtil.removeProject((String)app.name, (String)app.projectID, (IProgressMonitor)mon.split(20));
                    }
                    catch (Exception e) {
                        Logger.logError((String)("An error occurred while trying to remove the project after bind project terminated for: " + projectName), (Throwable)e);
                        return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ProjectCleanupError, (Object)projectName), null);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private boolean checkInstallStatus() {
        final CodewindManager.InstallerStatus installerStatus = CodewindManager.getManager().getInstallerStatus();
        if (installerStatus != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CodewindInstall.installerActiveDialog(installerStatus);
                }
            });
            return false;
        }
        if (!CodewindManager.getManager().getInstallStatus().isInstalled()) {
            CodewindInstall.codewindInstallerDialog(this.project);
            return false;
        }
        BindProjectWizard.setupLocalConnection(this.connection, this);
        if (!this.connection.isConnected()) {
            CoreUtil.openDialog((boolean)true, (String)Messages.BindProjectErrorTitle, (String)NLS.bind((String)Messages.BindProjectConnectionError, (Object)this.connection.getName()));
            return false;
        }
        String projectError = this.getProjectError(this.connection, this.project);
        if (projectError != null) {
            CoreUtil.openDialog((boolean)true, (String)Messages.BindProjectErrorTitle, (String)projectError);
            return false;
        }
        return true;
    }

    private boolean checkRemoteStatus() {
        if (!this.connection.isConnected()) {
            BindProjectWizard.connectCodewind(this.connection, this);
        }
        if (!this.connection.isConnected()) {
            CoreUtil.openDialog((boolean)true, (String)Messages.BindProjectErrorTitle, (String)NLS.bind((String)Messages.BindProjectConnectionError, (Object)this.connection.getName()));
            return false;
        }
        String projectError = this.getProjectError(this.connection, this.project);
        if (projectError != null) {
            CoreUtil.openDialog((boolean)true, (String)Messages.BindProjectErrorTitle, (String)projectError);
            return false;
        }
        return true;
    }

    public static void setupLocalConnection(final CodewindConnection conn, Wizard wizard) {
        if (conn.isConnected()) {
            return;
        }
        final InstallStatus status = CodewindManager.getManager().getInstallStatus();
        if (status.isStarted()) {
            if (!conn.isConnected()) {
                Logger.logError((String)"Local Codewind is started but the connection has not been established or is down");
            }
            return;
        }
        if (!status.isInstalled()) {
            Logger.logError((String)"In BindProjectWizard run method and Codewind is not installed or has unknown status.");
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    ProcessHelper.ProcessResult result = InstallUtil.startCodewind((String)status.getVersion(), (IProgressMonitor)monitor);
                    if (result.getExitValue() != 0) {
                        Logger.logError((String)("Installer start failed with return code: " + result.getExitValue() + ", output: " + result.getOutput() + ", error: " + result.getError()));
                        String errorText = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
                        throw new InvocationTargetException(null, "There was a problem trying to start Codewind: " + errorText);
                    }
                    ViewHelper.refreshCodewindExplorerView(conn);
                }
                catch (TimeoutException e) {
                    throw new InvocationTargetException(e, "Codewind did not start in the expected time: " + e.getMessage());
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "An error occurred trying to start Codewind: " + e.getMessage());
                }
            }
        };
        try {
            if (wizard.getPageCount() > 0 && wizard.getContainer() != null) {
                wizard.getContainer().run(true, true, runnable);
            } else {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)"An error occurred trying to start Codewind", (Throwable)e);
        }
        catch (InterruptedException e) {
            Logger.logError((String)"Codewind start was interrupted", (Throwable)e);
        }
    }

    public static void connectCodewind(final CodewindConnection conn, Wizard wizard) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    conn.connect(monitor);
                    ViewHelper.refreshCodewindExplorerView(conn);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "An error occurred trying to connect to " + conn.getName() + ": " + e.getMessage());
                }
            }
        };
        try {
            if (wizard.getPageCount() > 0 && wizard.getContainer() != null) {
                wizard.getContainer().run(true, true, runnable);
            } else {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)("An error occurred trying to connect to: " + conn.getName()), (Throwable)e);
        }
        catch (InterruptedException e) {
            Logger.logError((String)("Codewind connect was interrupted for: " + conn.getName()), (Throwable)e);
        }
    }

    private String getProjectError(CodewindConnection connection, IProject project) {
        if (connection == null || project == null) {
            return null;
        }
        if (connection.getAppByLocation(project.getLocation()) != null) {
            return NLS.bind((String)Messages.BindProjectAlreadyExistsError, (Object[])new String[]{project.getName(), connection.getName()});
        }
        return null;
    }
}

