/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.connection.LocalConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.UIConstants;
import org.eclipse.codewind.ui.internal.actions.AddConnectionAction;
import org.eclipse.codewind.ui.internal.actions.BindAction;
import org.eclipse.codewind.ui.internal.actions.LocalDoubleClickAction;
import org.eclipse.codewind.ui.internal.actions.NewProjectAction;
import org.eclipse.codewind.ui.internal.editors.WelcomePageEditorInput;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.UpdateHandler;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.EditorPart;

public class WelcomePageEditorPart
extends EditorPart
implements UpdateHandler.UpdateListener {
    private ScrolledForm form = null;
    private Font boldFont;
    private Font medFont;
    private Font medBoldFont;
    private Font largeFont;
    private Control focusControl;
    private Composite radioSelectionComp;
    private Composite localComposite;
    private Composite remoteComposite;
    private Button imagesButton;
    private List<Button> localProjectButtons = new ArrayList<Button>();
    private List<Button> remoteProjectButtons = new ArrayList<Button>();

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof WelcomePageEditorInput)) {
            Logger.logError((String)("The editor input is not valid for the welcome page: " + input.getClass()));
            throw new PartInitException(Messages.WelcomePageEditorCreateError);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(Messages.WelcomePageEditorPartName);
        CodewindUIPlugin.getUpdateHandler().addUpdateListener(this);
    }

    public void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.medFont != null) {
            this.medFont.dispose();
        }
        if (this.medBoldFont != null) {
            this.medBoldFont.dispose();
        }
        if (this.largeFont != null) {
            this.largeFont.dispose();
        }
        CodewindUIPlugin.getUpdateHandler().removeUpdateListener(this);
        super.dispose();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        ManagedForm managedForm = new ManagedForm(parent);
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.form.getForm());
        this.form.setImage(CodewindUIPlugin.getImage("codewindBanner.png"));
        this.form.setText(Messages.WelcomePageEditorFormTitle);
        this.form.setMessage(Messages.WelcomePageEditorFormMessage, 0);
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.boldFont = IDEUtil.newFont(parent.getShell(), parent.getFont(), 1);
        this.medFont = IDEUtil.newFont(parent.getShell(), parent.getFont(), 10, 0);
        this.medBoldFont = IDEUtil.newFont(parent.getShell(), parent.getFont(), 10, 1);
        this.largeFont = IDEUtil.newFont(parent.getShell(), parent.getFont(), 14, 0);
        int borderStyle = toolkit.getBorderStyle();
        toolkit.setBorderStyle(0);
        Composite welcomeComp = toolkit.createComposite(this.form.getBody());
        welcomeComp.setLayout((Layout)this.getCompLayout(10, 20, 2));
        welcomeComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Text welcomeLabel = toolkit.createText(welcomeComp, Messages.WelcomePageWelcomeHeader, 8);
        welcomeLabel.setFont(this.largeFont);
        welcomeLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        IDEUtil.paintBackgroundToMatch((Control)welcomeLabel, (Control)welcomeComp);
        this.focusControl = welcomeLabel;
        Label imageLabel = toolkit.createLabel(welcomeComp, "");
        imageLabel.setImage(CodewindUIPlugin.getImage("welcome.png"));
        imageLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 4));
        Text welcomeText = toolkit.createText(welcomeComp, Messages.WelcomePageWelcomeText, 72);
        IDEUtil.paintBackgroundToMatch((Control)welcomeText, (Control)welcomeComp);
        welcomeText.setLayoutData((Object)new GridData(4, 4, true, false));
        Hyperlink viewLink = toolkit.createHyperlink(welcomeComp, Messages.WelcomePageCodewindExplorerLink, 64);
        viewLink.setLayoutData((Object)new GridData(2, 4, false, false));
        this.setHyperlinkAction(viewLink, () -> ViewHelper.openCodewindExplorerView());
        toolkit.createSeparator(this.form.getBody(), 258).setLayoutData((Object)new GridData(4, 4, true, false));
        Composite quickStartComp = toolkit.createComposite(this.form.getBody());
        quickStartComp.setLayout((Layout)this.getCompLayout(10, 20, 2));
        quickStartComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Text quickStartLabel = toolkit.createText(quickStartComp, Messages.WelcomePageQuickStartHeader, 8);
        quickStartLabel.setFont(this.largeFont);
        IDEUtil.paintBackgroundToMatch((Control)quickStartLabel, (Control)quickStartComp);
        quickStartLabel.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Text quickStartText = toolkit.createText(quickStartComp, Messages.WelcomePageQuickStartText, 72);
        IDEUtil.paintBackgroundToMatch((Control)quickStartText, (Control)quickStartComp);
        quickStartText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Composite radioComp = toolkit.createComposite(quickStartComp);
        radioComp.setLayout((Layout)this.getCompLayout(10, 0, 2));
        radioComp.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        final Button localButton = toolkit.createButton(radioComp, Messages.WelcomePageQuickStartLocalButton, 16);
        localButton.setImage(CodewindUIPlugin.getImage("obj16/local_active.png"));
        localButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        final Button remoteButton = toolkit.createButton(radioComp, Messages.WelcomePageQuickStartRemoteButton, 16);
        remoteButton.setImage(CodewindUIPlugin.getImage("obj16/remote_connected.png"));
        remoteButton.setLayoutData((Object)new GridData(16384, 4, false, false));
        this.radioSelectionComp = toolkit.createComposite(radioComp);
        this.radioSelectionComp.setLayout((Layout)this.getCompLayout(10, 0, 1));
        this.radioSelectionComp.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.localComposite = this.createQuickStartComposite(toolkit, this.radioSelectionComp, true);
        this.remoteComposite = this.createQuickStartComposite(toolkit, this.radioSelectionComp, false);
        localButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (localButton.getSelection()) {
                    WelcomePageEditorPart.this.setQuickStartComp(true);
                }
            }
        });
        remoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (remoteButton.getSelection()) {
                    WelcomePageEditorPart.this.setQuickStartComp(false);
                }
            }
        });
        toolkit.createSeparator(this.form.getBody(), 258).setLayoutData((Object)new GridData(4, 4, true, false));
        Composite learnComp = toolkit.createComposite(this.form.getBody());
        learnComp.setLayout((Layout)this.getCompLayout(10, 20, 1));
        learnComp.setLayoutData((Object)new GridData(4, 4, true, false));
        Text learnLabel = toolkit.createText(learnComp, Messages.WelcomePageLearnHeader, 8);
        learnLabel.setFont(this.largeFont);
        IDEUtil.paintBackgroundToMatch((Control)learnLabel, (Control)learnComp);
        learnLabel.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        Composite learnInnerComp = toolkit.createComposite(learnComp);
        learnInnerComp.setLayout((Layout)this.getCompLayout(10, 0, 1));
        learnInnerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        ImageHyperlink commandsLink = toolkit.createImageHyperlink(learnInnerComp, 131072);
        commandsLink.setText(Messages.WelcomePageLearnCommandsLabel);
        commandsLink.setToolTipText(Messages.WelcomePageLearnCommandsTooltip);
        commandsLink.setFont(this.medBoldFont);
        commandsLink.setImage(CodewindUIPlugin.getImage("elcl16/open_app.png"));
        this.setHyperlinkAction((Hyperlink)commandsLink, () -> ViewHelper.openCodewindExplorerView());
        Text commandsText = toolkit.createText(learnInnerComp, Messages.WelcomePageLearnCommandsText, 72);
        IDEUtil.paintBackgroundToMatch((Control)commandsText, (Control)learnInnerComp);
        commandsText.setLayoutData((Object)new GridData(4, 4, true, false));
        Hyperlink commandsDocLink = toolkit.createHyperlink(learnInnerComp, Messages.WelcomePageLearnCommandsLink, 64);
        commandsDocLink.setToolTipText(Messages.WelcomePageLearnCommandsLinkTooltip);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 40;
        commandsDocLink.setLayoutData((Object)data);
        this.setHyperlinkAction(commandsDocLink, () -> IDEUtil.openExternalBrowser(UIConstants.COMMANDS_OVERVIEW_URL));
        toolkit.createLabel(learnInnerComp, "", 0);
        ImageHyperlink docsLink = toolkit.createImageHyperlink(learnInnerComp, 131072);
        docsLink.setText(Messages.WelcomePageLearnDocsLabel);
        docsLink.setToolTipText(Messages.WelcomePageLearnDocsTooltip);
        docsLink.setFont(this.medBoldFont);
        docsLink.setImage(CodewindUIPlugin.getImage("elcl16/open_app.png"));
        this.setHyperlinkAction((Hyperlink)docsLink, () -> IDEUtil.openExternalBrowser(UIConstants.DOC_BASE_URL));
        Text docsText = toolkit.createText(learnInnerComp, Messages.WelcomePageLearnDocsText, 72);
        IDEUtil.paintBackgroundToMatch((Control)docsText, (Control)learnInnerComp);
        docsText.setLayoutData((Object)new GridData(4, 4, true, false));
        Hyperlink templatesDocLink = toolkit.createHyperlink(learnInnerComp, Messages.WelcomePageLearnDocsTemplatesLink, 64);
        templatesDocLink.setToolTipText(Messages.WelcomePageLearnDocsTemplatesTooltip);
        data = new GridData(4, 4, true, false);
        data.horizontalIndent = 40;
        templatesDocLink.setLayoutData((Object)data);
        this.setHyperlinkAction(templatesDocLink, () -> IDEUtil.openExternalBrowser(UIConstants.TEMPLATES_INFO_URL));
        Hyperlink remoteDocLink = toolkit.createHyperlink(learnInnerComp, Messages.WelcomePageLearnDocsRemoteLink, 64);
        remoteDocLink.setToolTipText(Messages.WelcomePageLearnDocsRemoteTooltip);
        data = new GridData(4, 4, true, false);
        data.horizontalIndent = 40;
        remoteDocLink.setLayoutData((Object)data);
        this.setHyperlinkAction(remoteDocLink, () -> IDEUtil.openExternalBrowser(UIConstants.REMOTE_DEPLOY_URL));
        toolkit.createLabel(learnInnerComp, "", 0);
        Label extensionsLabel = toolkit.createLabel(learnInnerComp, Messages.WelcomePageLearnExtensionsLabel);
        extensionsLabel.setForeground(docsLink.getForeground());
        extensionsLabel.setFont(this.medBoldFont);
        Text extensionsText = toolkit.createText(learnInnerComp, Messages.WelcomePageLearnExtensionsText, 72);
        IDEUtil.paintBackgroundToMatch((Control)extensionsText, (Control)learnInnerComp);
        extensionsText.setLayoutData((Object)new GridData(4, 4, true, false));
        Hyperlink openAPILink = toolkit.createHyperlink(learnInnerComp, Messages.WelcomePageLearnExtensionsOpenAPILink, 64);
        openAPILink.setToolTipText(Messages.WelcomePageLearnExtensionsOpenAPITooltip);
        data = new GridData(4, 4, true, false);
        data.horizontalIndent = 40;
        openAPILink.setLayoutData((Object)data);
        this.setHyperlinkAction(openAPILink, () -> IDEUtil.openExternalBrowser("https://marketplace.eclipse.org/content/codewind-openapi-tools"));
        Hyperlink dockerToolsLink = toolkit.createHyperlink(learnInnerComp, Messages.WelcomePageLearnExtensionsDockerLink, 64);
        dockerToolsLink.setToolTipText(Messages.WelcomePageLearnExtensionsDockerTooltip);
        data = new GridData(4, 4, true, false);
        data.horizontalIndent = 40;
        dockerToolsLink.setLayoutData((Object)data);
        this.setHyperlinkAction(dockerToolsLink, () -> IDEUtil.openExternalBrowser("https://marketplace.eclipse.org/content/eclipse-docker-tooling"));
        toolkit.setBorderStyle(borderStyle);
        localButton.setSelection(true);
        this.setQuickStartComp(true);
        this.updateButtons();
    }

    private GridLayout getCompLayout(int hSpacing, int vSpacing, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = hSpacing;
        layout.verticalSpacing = vSpacing;
        layout.numColumns = numColumns;
        return layout;
    }

    private void setHyperlinkAction(Hyperlink link, final LinkAction action) {
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent arg0) {
                action.execute();
            }
        });
    }

    private void setQuickStartComp(boolean isLocal) {
        this.localComposite.setVisible(isLocal);
        ((GridData)this.localComposite.getLayoutData()).exclude = !isLocal;
        this.remoteComposite.setVisible(!isLocal);
        ((GridData)this.remoteComposite.getLayoutData()).exclude = isLocal;
        this.radioSelectionComp.requestLayout();
    }

    private Composite createQuickStartComposite(FormToolkit toolkit, Composite parent, final boolean isLocal) {
        Composite comp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        layout.horizontalSpacing = 70;
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite setupComp = toolkit.createComposite(comp);
        layout = new GridLayout();
        layout.verticalSpacing = 8;
        layout.horizontalSpacing = 15;
        setupComp.setLayout((Layout)layout);
        setupComp.setLayoutData((Object)new GridData(4, 4, false, false));
        toolkit.createSeparator(comp, 514).setLayoutData((Object)new GridData(4, 4, false, false));
        Composite projectComp = toolkit.createComposite(comp);
        layout = new GridLayout();
        layout.verticalSpacing = 8;
        layout.horizontalSpacing = 15;
        projectComp.setLayout((Layout)layout);
        projectComp.setLayoutData((Object)new GridData(4, 4, false, false));
        ArrayList<Button> buttons = new ArrayList<Button>();
        Text setupLabel = toolkit.createText(setupComp, Messages.WelcomePageQuickStartSetUpLabel, 8);
        setupLabel.setFont(this.medBoldFont);
        IDEUtil.paintBackgroundToMatch((Control)setupLabel, (Control)setupComp);
        setupLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        Text stepLabel = toolkit.createText(setupComp, NLS.bind((String)Messages.WelcomePageQuickStartStep, (Object)1), 8);
        IDEUtil.paintBackgroundToMatch((Control)stepLabel, (Control)setupComp);
        stepLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        if (isLocal) {
            Button dockerButton = new Button(setupComp, 8);
            dockerButton.setText(Messages.WelcomePageQuickStartInstallDockerButton);
            dockerButton.setFont(this.medFont);
            dockerButton.setLayoutData((Object)new GridData(4, 4, false, false));
            buttons.add(dockerButton);
            dockerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    IDEUtil.openExternalBrowser("https://docs.docker.com/install/");
                }
            });
            stepLabel = toolkit.createText(setupComp, NLS.bind((String)Messages.WelcomePageQuickStartStep, (Object)2), 8);
            IDEUtil.paintBackgroundToMatch((Control)stepLabel, (Control)setupComp);
            stepLabel.setLayoutData((Object)new GridData(4, 4, false, false));
            this.imagesButton = new Button(setupComp, 8);
            this.imagesButton.setText(Messages.WelcomePageQuickStartInstallImagesButton);
            this.imagesButton.setFont(this.medFont);
            this.imagesButton.setLayoutData((Object)new GridData(4, 4, false, false));
            buttons.add(this.imagesButton);
            this.imagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    LocalConnection connection = (LocalConnection)CodewindConnectionManager.getLocalConnection();
                    LocalDoubleClickAction.performInstall(connection, false);
                }
            });
        } else {
            Button connectionButton = new Button(setupComp, 8);
            connectionButton.setText(Messages.WelcomePageQuickStartNewConnectionButton);
            connectionButton.setFont(this.medFont);
            connectionButton.setLayoutData((Object)new GridData(4, 4, false, false));
            buttons.add(connectionButton);
            connectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    AddConnectionAction.openConnectionWizard();
                }
            });
        }
        Text projectLabel = toolkit.createText(projectComp, Messages.WelcomePageQuickStartProjectLabel, 8);
        projectLabel.setFont(this.medBoldFont);
        IDEUtil.paintBackgroundToMatch((Control)projectLabel, (Control)projectComp);
        projectLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        stepLabel = toolkit.createText(projectComp, NLS.bind((String)Messages.WelcomePageQuickStartStep, (Object)(isLocal ? 3 : 2)), 8);
        IDEUtil.paintBackgroundToMatch((Control)stepLabel, (Control)projectComp);
        stepLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        Button newProjectButton = new Button(projectComp, 8);
        newProjectButton.setText(Messages.WelcomePageQuickStartNewProjectButton);
        newProjectButton.setFont(this.medFont);
        newProjectButton.setLayoutData((Object)new GridData(4, 4, false, false));
        buttons.add(newProjectButton);
        newProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (isLocal) {
                    NewProjectAction.openNewProjectWizard(CodewindConnectionManager.getLocalConnection());
                } else {
                    List connections = CodewindConnectionManager.activeRemoteConnections();
                    if (connections.isEmpty()) {
                        IDEUtil.openInfoDialog(Messages.WelcomePageQuickStartNoConnectionTitle, Messages.WelcomePageQuickStartNoConnectionMsg);
                    } else {
                        NewProjectAction.openNewProjectWizard(connections);
                    }
                }
            }
        });
        Text orLabel = toolkit.createText(projectComp, Messages.WelcomePageQuickStartOr, 8);
        IDEUtil.paintBackgroundToMatch((Control)orLabel, (Control)projectComp);
        orLabel.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        Button addProjectButton = new Button(projectComp, 8);
        addProjectButton.setText(Messages.WelcomePageQuickStartAddProjectButton);
        addProjectButton.setFont(this.medFont);
        addProjectButton.setLayoutData((Object)new GridData(4, 4, false, false));
        buttons.add(addProjectButton);
        addProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (isLocal) {
                    BindAction.openBindProjectWizard(CodewindConnectionManager.getLocalConnection());
                } else {
                    List connections = CodewindConnectionManager.activeRemoteConnections();
                    if (connections.isEmpty()) {
                        IDEUtil.openInfoDialog(Messages.WelcomePageQuickStartNoConnectionTitle, Messages.WelcomePageQuickStartNoConnectionMsg);
                    } else {
                        BindAction.openBindProjectWizard(connections);
                    }
                }
            }
        });
        List<Button> projectButtons = isLocal ? this.localProjectButtons : this.remoteProjectButtons;
        projectButtons.add(newProjectButton);
        projectButtons.add(addProjectButton);
        this.sizeButtons(buttons);
        return comp;
    }

    @Override
    public void update(UpdateHandler.UpdateType type, Object element) {
        if (element == null || element instanceof CodewindConnection) {
            Display.getDefault().asyncExec(() -> this.updateButtons());
        }
    }

    private void updateButtons() {
        if (this.imagesButton == null || this.imagesButton.isDisposed() || this.localProjectButtons.isEmpty() || this.remoteProjectButtons.isEmpty()) {
            return;
        }
        boolean installing = CodewindManager.getManager().getInstallerStatus() != null;
        this.imagesButton.setEnabled(!installing);
        boolean running = CodewindManager.getManager().getInstallStatus().isStarted();
        this.localProjectButtons.stream().forEach(button -> {
            if (!button.isDisposed()) {
                button.setEnabled(!installing && running);
            }
        });
        boolean hasRemoteConnections = !CodewindConnectionManager.activeRemoteConnections().isEmpty();
        this.remoteProjectButtons.stream().forEach(button -> {
            if (!button.isDisposed()) {
                button.setEnabled(hasRemoteConnections);
            }
        });
    }

    private void sizeButtons(List<Button> buttons) {
        int width = 0;
        for (Button button : buttons) {
            int x = button.computeSize((int)-1, (int)-1).x;
            width = x > width ? x : width;
        }
        width += 10;
        for (Button button : buttons) {
            ((GridData)button.getLayoutData()).widthHint = width;
        }
    }

    public void setFocus() {
        if (this.focusControl != null) {
            this.focusControl.setFocus();
        }
    }

    public static interface LinkAction {
        public void execute();
    }
}

