/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.marker;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;

public class CodewindMarkerResolution
implements IMarkerResolution {
    private final CodewindApplication app;
    private final String quickFixId;
    private final String quickFixDescription;

    public CodewindMarkerResolution(CodewindApplication app, String quickFixId, String quickFixDescription) {
        this.app = app;
        this.quickFixId = quickFixId;
        this.quickFixDescription = quickFixDescription;
    }

    public String getLabel() {
        return this.quickFixDescription;
    }

    public void run(IMarker marker) {
        try {
            this.app.connection.requestValidateGenerate(this.app);
            final IResource resource = marker.getResource();
            if (resource != null) {
                Job job = new Job(NLS.bind((String)Messages.refreshResourceJobLabel, (Object)resource.getName())){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            resource.refreshLocal(2, monitor);
                            return Status.OK_STATUS;
                        }
                        catch (Exception e) {
                            Logger.logError((String)("An error occurred while refreshing the resource: " + resource.getLocation()));
                            return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.RefreshResourceError, (Object)resource.getLocation()), (Throwable)e);
                        }
                    }
                };
                job.setPriority(30);
                job.schedule();
            }
        }
        catch (Exception e) {
            Logger.logError((String)("The generate request failed for application: " + this.app.name), (Throwable)e);
        }
    }
}

