/*******************************************************************************
* Copyright (c) 2019, 2020 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
/**
 * A file-based logger that maintains at most only the last (2 *
 * MAX_LOG_FILE_SIZE)-1 bytes, in at most 2 log files. Log files are stored in
 * the given directory.
 *
 * At most 2 log files will exist at any one time: n-1, n
 */
export declare class FileLogger {
    static readonly FILE_PREFIX = "filewatcherd-";
    static readonly FILE_SUFFIX = ".log";
    static readonly MAX_LOG_FILE_SIZE: number;
    private _logDir;
    private _bytesWritten;
    private _nextNumber;
    private _fd;
    private _initialized;
    constructor(logDir: string);
    log(str: string): void;
    private logInner;
}
