/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Enumeration;
import org.eclipse.codewind.intellij.core.Logger;

public class PlatformUtil {
    public static OperatingSystem getOS() {
        String osName = System.getProperty("os.name");
        return PlatformUtil.getOS(osName);
    }

    public static OperatingSystem getOS(String osName) {
        if (osName == null || osName.isEmpty()) {
            Logger.logWarning("The operating system name is null or empty, defaulting to Linux.");
            return OperatingSystem.LINUX;
        }
        String name = osName.toLowerCase();
        if (name.contains("win")) {
            return OperatingSystem.WINDOWS;
        }
        if (name.contains("mac")) {
            return OperatingSystem.MAC;
        }
        if (name.contains("linux")) {
            return OperatingSystem.LINUX;
        }
        Logger.logWarning("The operating system name is not valid: " + osName + ", defaulting to Linux.");
        return OperatingSystem.LINUX;
    }

    public static int findFreePort() {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return -1;
    }

    public static String getHostName() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            Enumeration<InetAddress> ee = n.getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress i = ee.nextElement();
                if (i.isSiteLocalAddress() || i.isLinkLocalAddress() || i.isLoopbackAddress() || i.isAnyLocalAddress() || i.isMulticastAddress()) continue;
                return i.getHostName();
            }
        }
        throw new SocketException("Failed to get the IP address for the local host");
    }

    public static enum OperatingSystem {
        LINUX,
        MAC,
        WINDOWS;

    }
}

