/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.module;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.FileUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.ProjectUtil;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;

public class SetupCodewindProjectRunnable
implements Runnable {
    private String path;
    private String name;
    private String url;
    private String language;
    private String projectType;
    private String conId;
    private String javaHome;

    public SetupCodewindProjectRunnable(String path, String name, String url, String language, String projectType, String conId, String javaHome) {
        this.path = path;
        this.name = name;
        this.url = url;
        this.language = language;
        this.projectType = projectType;
        this.conId = conId;
        this.javaHome = javaHome;
    }

    @Override
    public void run() throws ProcessCanceledException {
        block2: {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            try {
                progressIndicator.setIndeterminate(false);
                progressIndicator.setText2(CodewindUIBundle.message("PleaseWaitForBuild", new Object[0]));
                Path projectPath = Paths.get(this.path, new String[0]);
                progressIndicator.checkCanceled();
                Path tmpProjectPath = Files.createTempDirectory("codewind", new FileAttribute[0]).resolve(projectPath.getFileName());
                progressIndicator.checkCanceled();
                progressIndicator.setText(CodewindUIBundle.message("SettingUpProject", new Object[0]));
                ProjectUtil.createProject(this.name, tmpProjectPath.toString(), this.url, this.conId, this.javaHome, progressIndicator);
                progressIndicator.checkCanceled();
                FileUtil.copyDirectory(tmpProjectPath, projectPath);
                progressIndicator.checkCanceled();
                progressIndicator.setText("Binding project");
                ProjectUtil.bindProject(this.name, this.path, this.language, this.projectType, this.conId, progressIndicator);
                progressIndicator.checkCanceled();
                FileUtil.deleteDirectory(tmpProjectPath.getParent().toString(), true);
                progressIndicator.checkCanceled();
                progressIndicator.stop();
            }
            catch (Exception error) {
                if (error instanceof ProcessCanceledException) break block2;
                Throwable thrown = Logger.unwrap(error);
                Logger.logWarning("An error occurred creating project " + this.name, thrown);
                CoreUtil.openDialog(CoreUtil.DialogType.ERROR, CodewindUIBundle.message("NewProjectPage_ProjectCreateErrorTitle", new Object[0]), CodewindUIBundle.message("StartBuildError", this.name, thrown.getLocalizedMessage()));
            }
        }
    }
}

