/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.KubeUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.ui.actions.AbstractProjectDependentAction;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalView;

public class OpenContainerShellAction
extends AbstractProjectDependentAction {
    public OpenContainerShellAction() {
        super(CodewindUIBundle.message("ActionOpenContainerShell", new Object[0]));
    }

    @Override
    protected Task.Backgroundable getTaskToRun(final CodewindApplication app, Project project) {
        return new Task.Backgroundable(project, CodewindUIBundle.message("ActionOpenContainerShell", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                CoreUtil.invokeLater(this::run0);
            }

            public void run0() {
                String command = "sh -c \"if type bash > /dev/null; then bash; else sh; fi\"";
                String processPath = null;
                String processArgs = null;
                if (app.connection.isLocal()) {
                    String envPath = CoreUtil.getEnvPath();
                    processPath = envPath != null ? envPath + "docker" : "docker";
                    processArgs = "exec -it " + app.getContainerId() + " " + command;
                } else {
                    processPath = KubeUtil.getCommand();
                    if (processPath == null) {
                        Logger.logWarning("The container shell cannot be opened because neither of the kubectl or oc commands could be found on the path");
                        CoreUtil.openDialog(true, CodewindUIBundle.message("ActionOpenContainerShellErrorTitle", new Object[0]), CodewindUIBundle.message("ActionOpenContainerShellNoKubectlMsg", new Object[0]));
                        return;
                    }
                    processArgs = "exec -n " + app.getNamespace() + " -it " + app.getPodName() + " -- " + command;
                }
                String cmd = processPath + " " + processArgs;
                TerminalView terminalView = TerminalView.getInstance((Project)this.myProject);
                try {
                    ShellTerminalWidget w = terminalView.createLocalShellWidget(null);
                    w.executeCommand(cmd);
                    w.requestFocusInWindow();
                }
                catch (IOException e) {
                    Logger.logWarning(e);
                    CoreUtil.openDialog(true, CodewindUIBundle.message("ActionOpenContainerShellErrorTitle", new Object[0]), e.getLocalizedMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/eclipse/codewind/intellij/ui/actions/OpenContainerShellAction$1", "run"));
            }
        };
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        CodewindApplication application;
        if (e == null) {
            OpenContainerShellAction.$$$reportNull$$$0(0);
        }
        if ((application = this.getSelection(e)) == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        boolean isCurrentOpenedProject = this.openProjectInIde(application, project);
        if (isCurrentOpenedProject) {
            ProgressManager.getInstance().run((Task)this.getTaskToRun(application, project));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenContainerShellAction.$$$reportNull$$$0(1);
        }
        CodewindApplication application = this.getSelection(e);
        e.getPresentation().setEnabled(this.shouldEnable(application));
    }

    private boolean shouldEnable(CodewindApplication application) {
        if (application == null) {
            return false;
        }
        if (!application.isAvailable()) {
            return false;
        }
        if (application.connection.isLocal()) {
            return application.getContainerId() != null;
        }
        return application.getPodName() != null && application.getNamespace() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/actions/OpenContainerShellAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

