/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.eclipse.codewind.intellij.core.Logger;

public class FileUtil {
    public static boolean makeDir(String path) {
        boolean result = true;
        if (path != null) {
            try {
                File fp = new File(path);
                if (!fp.exists() || !fp.isDirectory()) {
                    result = fp.mkdirs();
                }
            }
            catch (Exception e) {
                Logger.logWarning("Failed to create directory: " + path, e);
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream inStream, String path) throws IOException, FileNotFoundException {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(path);
            byte[] bytes = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = inStream.read(bytes)) > 0) {
                outStream.write(bytes, 0, bytesRead);
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteDirectory(String dir, boolean recursive) throws IOException {
        boolean isSuccess;
        String[] fileList;
        if (dir == null || dir.length() <= 0) {
            return;
        }
        if (new StringTokenizer(dir.replace(File.separatorChar, '/'), "/").countTokens() < 2) {
            return;
        }
        File fp = new File(dir);
        if (!fp.exists() || !fp.isDirectory()) {
            throw new IOException("Directory does not exist: " + fp.toString());
        }
        if (recursive && (fileList = fp.list()) != null) {
            String curBasePath = dir + File.separator;
            for (int i = 0; i < fileList.length; ++i) {
                File curFp = new File(curBasePath + fileList[i]);
                if (!curFp.exists()) continue;
                if (curFp.isDirectory()) {
                    FileUtil.deleteDirectory(dir + File.separator + fileList[i], recursive);
                    continue;
                }
                if (curFp.delete()) continue;
                Logger.log("Could not delete " + curFp.getName());
            }
        }
        if (!(isSuccess = fp.delete())) {
            throw new IOException("Directory cannot be removed.");
        }
    }

    public static String getCanonicalPath(String path) {
        String canonicalPath = path;
        try {
            canonicalPath = new File(path).getCanonicalPath();
        }
        catch (Exception e) {
            Logger.log("Failed to get the canonical path for: " + path + ". " + e.getMessage());
        }
        return canonicalPath;
    }

    public static boolean isSamePath(String path1, String path2) {
        boolean isEqual = false;
        try {
            File filePath1 = new File(path1);
            File filePath2 = new File(path2);
            isEqual = filePath1.getCanonicalPath().equals(filePath2.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isEqual;
    }

    public static void copyDirectory(Path source, Path target) throws IOException {
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        try (Stream<Path> files = Files.walk(source, new FileVisitOption[0]);){
            files.filter(file -> !file.equals(source)).map(source::relativize).forEach(file -> FileUtil.copyFile(source.resolve((Path)file), target.resolve((Path)file)));
        }
    }

    private static void copyFile(Path source, Path target) {
        try {
            if (Files.isDirectory(source, new LinkOption[0])) {
                Files.createDirectories(target, new FileAttribute[0]);
                return;
            }
            Files.copy(source, target, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

