/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.constants;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.codewind.intellij.core.messages.CodewindCoreBundle;

public class ProjectLanguage {
    public static final ProjectLanguage LANGUAGE_JAVA = new ProjectLanguage("java", "Java");
    public static final ProjectLanguage LANGUAGE_JAVASCRIPT = new ProjectLanguage("javascript", "JavaScript");
    public static final ProjectLanguage LANGUAGE_NODEJS = new ProjectLanguage("nodejs", "Node.js");
    public static final ProjectLanguage LANGUAGE_SWIFT = new ProjectLanguage("swift", "Swift");
    public static final ProjectLanguage LANGUAGE_GO = new ProjectLanguage("go", "Go");
    public static final ProjectLanguage LANGUAGE_PYTHON = new ProjectLanguage("python", "Python");
    public static final ProjectLanguage LANGUAGE_BASH = new ProjectLanguage("bash", "Bash");
    public static final ProjectLanguage LANGUAGE_UNKNOWN = new ProjectLanguage("unknown", CodewindCoreBundle.message("GenericUnknown", new Object[0]));
    private static final Map<String, ProjectLanguage> defaultLanguages = new HashMap<String, ProjectLanguage>();
    private final String id;
    private final String displayName;

    private ProjectLanguage(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ProjectLanguage getLanguage(String id) {
        ProjectLanguage language;
        ProjectLanguage projectLanguage = language = id == null ? LANGUAGE_UNKNOWN : defaultLanguages.get(id);
        if (language == null) {
            language = new ProjectLanguage(id, id);
        }
        return language;
    }

    public boolean isUnknown() {
        return "unknown".equals(this.id);
    }

    public boolean isJavaScript() {
        return "javascript".equals(this.id) || "nodejs".equals(this.id);
    }

    public boolean isJava() {
        return "java".equals(this.id);
    }

    public boolean isSwift() {
        return "swift".equals(this.id);
    }

    public boolean isGo() {
        return "go".equals(this.id);
    }

    public boolean isPython() {
        return "python".equals(this.id);
    }

    public static String getDisplayName(String id) {
        if (id == null) {
            return CodewindCoreBundle.message("GenericUnknown", new Object[0]);
        }
        ProjectLanguage language = defaultLanguages.get(id);
        if (language != null) {
            return language.getDisplayName();
        }
        return id;
    }

    static {
        defaultLanguages.put("java", LANGUAGE_JAVA);
        defaultLanguages.put("javascript", LANGUAGE_JAVASCRIPT);
        defaultLanguages.put("nodejs", LANGUAGE_NODEJS);
        defaultLanguages.put("swift", LANGUAGE_SWIFT);
        defaultLanguages.put("go", LANGUAGE_GO);
        defaultLanguages.put("python", LANGUAGE_PYTHON);
        defaultLanguages.put("bash", LANGUAGE_BASH);
        defaultLanguages.put("unknown", LANGUAGE_UNKNOWN);
    }
}

