/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.io.EOFException;
import java.net.SocketException;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.internal.WebSocketManagerThread;

public class WSClientEndpoint
extends WebSocketListener {
    private static final FWLogger log = FWLogger.getInstance();
    private final WebSocketManagerThread parent;
    private final String wsUrl;

    public WSClientEndpoint(WebSocketManagerThread parent, String wsUrl) {
        this.parent = parent;
        this.wsUrl = wsUrl;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        log.logInfo("WebSocket connection opened for " + this.wsUrl);
        if (this.parent != null) {
            this.parent.informConnectionSuccess(webSocket);
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        log.logInfo("WebSocket connection closed with reason: " + code + " " + reason + ", for url: " + this.wsUrl);
        if (this.parent != null) {
            this.parent.informConnectionClosedOrFailed(webSocket);
        }
    }

    public void onMessage(WebSocket webSocket, String msg) {
        if (this.parent != null) {
            this.parent.receiveMessage(msg);
        }
    }

    public void onFailure(WebSocket webSocket, Throwable thr, Response response) {
        boolean printThrowable = true;
        if (thr.getMessage() != null && thr.getMessage().contains("Failed to connect to ")) {
            printThrowable = false;
        }
        if (thr instanceof EOFException || thr instanceof SocketException) {
            printThrowable = false;
        }
        if (printThrowable) {
            log.logSevere("WebSocket onError throwable: " + thr + " for url: " + this.wsUrl);
            thr.printStackTrace();
        } else {
            log.logError("WebSocket onError - Unable to connect for url: " + this.wsUrl);
        }
        if (this.parent != null) {
            this.parent.informConnectionClosedOrFailed(webSocket);
        }
    }
}

