/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.templates;

import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.templates.AbstractAddTemplateSourceWizardStep;
import org.eclipse.codewind.intellij.ui.templates.DetailsStep;
import org.eclipse.codewind.intellij.ui.templates.RepoEntry;
import org.eclipse.codewind.intellij.ui.templates.UrlStep;
import org.eclipse.codewind.intellij.ui.templates.form.AuthForm;
import org.eclipse.codewind.intellij.ui.wizard.AbstractCodewindWizard;
import org.eclipse.codewind.intellij.ui.wizard.AbstractCodewindWizardStep;
import org.eclipse.codewind.intellij.ui.wizard.CodewindCommitStepException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTemplateSourceWizard
extends AbstractCodewindWizard {
    public AddTemplateSourceWizard(@Nullable Project project, List<? extends AbstractCodewindWizardStep> steps) {
        super(CodewindUIBundle.message("AddRepoDialogTitle", new Object[0]), project, steps, "https://www.eclipse.org/codewind/workingwithtemplates.html");
    }

    public AddTemplateSourceWizard(String title, @Nullable Project project, List<? extends AbstractCodewindWizardStep> steps) {
        super(title, project, steps, "https://www.eclipse.org/codewind/workingwithtemplates.html");
    }

    protected void doNextAction() {
        block2: {
            try {
                this.setErrorText(null);
                AbstractAddTemplateSourceWizardStep currentStepObject = (AbstractAddTemplateSourceWizardStep)this.getCurrentStepObject();
                currentStepObject.onStepLeaving();
                AbstractAddTemplateSourceWizardStep nextStepObject = (AbstractAddTemplateSourceWizardStep)this.getNextStepObject();
                nextStepObject.onStepEntering();
                super.doNextAction();
                nextStepObject.postDoNextStep();
            }
            catch (CodewindCommitStepException e) {
                CoreUtil.openDialog(true, e.getTitle(), e.getMessage());
                if (e.getComponent() == null) break block2;
                this.setErrorText(e.getMessage(), e.getComponent());
            }
        }
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        List list = super.doValidateAll();
        if (list == null) {
            AddTemplateSourceWizard.$$$reportNull$$$0(0);
        }
        return list;
    }

    protected void doPreviousAction() {
        try {
            AbstractAddTemplateSourceWizardStep currentStepObject = (AbstractAddTemplateSourceWizardStep)this.getCurrentStepObject();
            currentStepObject.onStepLeaving();
            super.doPreviousAction();
        }
        catch (CommitStepException commitStepException) {
            // empty catch block
        }
    }

    @Override
    protected void doOKAction() {
        super.doOKAction();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object source = changeEvent.getSource();
        if (source instanceof JComponent) {
            JComponent component = (JComponent)source;
            if (this.hasErrors(component)) {
                this.setErrorText(null, (JComponent)source);
            }
        } else if (source == AuthForm.AUTH_SUCCESSFUL) {
            this.setErrorText(null);
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            AddTemplateSourceWizard.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        AbstractAddTemplateSourceWizardStep currentStepObject = (AbstractAddTemplateSourceWizardStep)this.getCurrentStepObject();
        return currentStepObject.doValidate();
    }

    public RepoEntry getRepoEntry() {
        UrlStep urlStep = (UrlStep)this.mySteps.get(0);
        DetailsStep detailsStep = (DetailsStep)this.mySteps.get(1);
        String url = urlStep.getTemplateSourceUrl();
        String name = detailsStep.getTemplateSourceName();
        String description = detailsStep.getTemplateSourceDescription();
        if (!(name == null || name.isEmpty() || description == null || description.isEmpty() || url == null || url.isEmpty())) {
            return new RepoEntry(url, urlStep.getUsername(), urlStep.getPassword(), urlStep.getToken(), name, description);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/eclipse/codewind/intellij/ui/templates/AddTemplateSourceWizard";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

