/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.form;

import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.codewind.intellij.core.connection.ProjectTypeInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectInfo;
import org.eclipse.codewind.intellij.core.constants.ProjectLanguage;
import org.eclipse.codewind.intellij.core.constants.ProjectType;
import org.eclipse.codewind.intellij.ui.IconCache;
import org.eclipse.codewind.intellij.ui.form.WidgetUtils;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.wizard.AbstractBindProjectWizardStep;
import org.jetbrains.annotations.Nullable;

public class ProjectTypeSelectionForm {
    private AbstractBindProjectWizardStep step;
    private JLabel chooseProjectTypeLabel;
    private JList<ProjectTypeInfo> projectTypeList;
    private JLabel subtypeLabel;
    private JList<ProjectTypeInfo.ProjectSubtypeInfo> subtypeList;
    private JLabel preferencesLabel;
    private JLabel manageTemplateSourcesLink;
    private JPanel contentPane;
    private DefaultListModel<ProjectTypeInfo> projectTypeListModel;
    private DefaultListModel<ProjectTypeInfo.ProjectSubtypeInfo> subTypeListModel;
    private Map<String, ProjectTypeInfo> projectTypes;
    private ProjectInfo initialProjectInfo;
    private ProjectTypeInfo.ProjectSubtypeInfo projectSubtypeInfo = null;

    public ProjectTypeSelectionForm(AbstractBindProjectWizardStep step) {
        this.step = step;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        if (this.projectTypeListModel == null) {
            this.projectTypeListModel = new DefaultListModel();
        }
        if (this.subTypeListModel == null) {
            this.subTypeListModel = new DefaultListModel();
        }
        this.projectTypeList = new JBList(this.projectTypeListModel);
        this.projectTypeList.setCellRenderer(new ProjectTypeListCellRenderer());
        this.projectTypeList.setSelectionMode(0);
        this.projectTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (ProjectTypeSelectionForm.this.projectTypeList.getSelectedIndex() >= 0) {
                        int selectedIndex = ProjectTypeSelectionForm.this.projectTypeList.getSelectedIndex();
                        ProjectTypeInfo selectedType = (ProjectTypeInfo)ProjectTypeSelectionForm.this.projectTypeListModel.getElementAt(selectedIndex);
                        ProjectTypeSelectionForm.this.subtypeList.removeAll();
                        ProjectTypeSelectionForm.this.fillSubTypesList(false, selectedType);
                        ProjectTypeSelectionForm.this.step.fireStateChanging();
                        return;
                    }
                    ProjectTypeSelectionForm.this.fillSubTypesList(false, null);
                    ProjectTypeSelectionForm.this.step.fireStateChanging();
                }
            }
        });
        this.subtypeLabel = new JLabel(CodewindUIBundle.message("SelectProjectTypePageLanguageLabel", new Object[0]));
        this.subtypeList = new JBList(this.subTypeListModel);
        this.subtypeList.setSelectionMode(0);
        this.subtypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProjectTypeSelectionForm.this.step.fireStateChanging();
            }
        });
        this.subtypeList.setCellRenderer(new SubTypeListCellRenderer());
        this.manageTemplateSourcesLink = WidgetUtils.createHyperlinkUsingLabel(CodewindUIBundle.message("SelectProjectTypeManageRepoLink", new Object[0]));
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    @Nullable
    public ProjectTypeInfo getSelectedProjectTypeInfo() {
        ProjectTypeInfo selectedValue = this.projectTypeList.getSelectedValue();
        return selectedValue;
    }

    @Nullable
    public ProjectTypeInfo.ProjectSubtypeInfo getSelectedSubtype() {
        ProjectTypeInfo.ProjectSubtypeInfo selectedValue = this.subtypeList.getSelectedValue();
        return selectedValue;
    }

    private void fillSubTypesList(boolean init, ProjectTypeInfo projectTypeInfo) {
        this.subtypeList.clearSelection();
        if (this.subTypeListModel == null) {
            this.subTypeListModel = new DefaultListModel();
        } else {
            this.subTypeListModel.removeAllElements();
        }
        boolean shouldShow = false;
        if (projectTypeInfo == null) {
            this.subtypeList.clearSelection();
        } else {
            boolean isDocker;
            List<ProjectTypeInfo.ProjectSubtypeInfo> projectSubtypes = projectTypeInfo.getSubtypes();
            for (ProjectTypeInfo.ProjectSubtypeInfo subtypeInfo : projectSubtypes) {
                if (!subtypeInfo.id.toLowerCase().contains(ProjectLanguage.LANGUAGE_JAVA.getId())) continue;
                this.subTypeListModel.addElement(subtypeInfo);
            }
            if (this.subTypeListModel.size() >= 1 && ((isDocker = projectTypeInfo.eq(ProjectType.TYPE_DOCKER)) || this.initialProjectInfo == null || !projectTypeInfo.eq(this.initialProjectInfo.type))) {
                if (init && isDocker && this.initialProjectInfo != null) {
                    ProjectTypeInfo projectTypeInfo2 = projectTypeInfo;
                    projectTypeInfo2.getClass();
                    this.projectSubtypeInfo = projectTypeInfo2.new ProjectTypeInfo.ProjectSubtypeInfo(this.initialProjectInfo.language.getId());
                    this.subtypeList.setSelectedValue(this.projectSubtypeInfo, true);
                }
                shouldShow = true;
                String label = projectTypeInfo.getSubtypesLabel();
                label = "".equals(label) ? CodewindUIBundle.message("SelectProjectTypePageLanguageLabel", new Object[0]) : CodewindUIBundle.message("SelectProjectTypePageSubtypeLabel", label);
                this.subtypeLabel.setText(label);
            }
        }
        if (!shouldShow) {
            this.subtypeLabel.setText("");
        }
        this.subtypeList.setVisible(shouldShow);
    }

    public void setProjectTypes(Map<String, ProjectTypeInfo> types) {
        this.projectTypes = types;
    }

    public void updateProjectTypesList(boolean init, Map<String, ProjectTypeInfo> types) {
        Set<String> keys = types.keySet();
        if (this.projectTypeListModel == null) {
            this.projectTypeListModel = new DefaultListModel();
        }
        if (init) {
            for (String s : keys) {
                ProjectTypeInfo info = types.get(s);
                if (!s.equals(ProjectType.TYPE_DOCKER.getId()) && !s.equals(ProjectType.TYPE_LIBERTY.getId()) && !s.equals(ProjectType.TYPE_SPRING.getId()) && !s.equals(ProjectType.TYPE_UNKNOWN.getId()) && !"appsodyExtension".equals(s)) continue;
                this.projectTypeListModel.addElement(info);
            }
        }
        int selectIndex = -1;
        int length = this.projectTypeListModel.size();
        if (this.initialProjectInfo != null) {
            for (int i = 0; i < length; ++i) {
                ProjectTypeInfo info = this.projectTypeListModel.get(i);
                if (!info.getId().equals(this.initialProjectInfo.type.getId())) continue;
                selectIndex = i;
                break;
            }
        }
        if (selectIndex >= 0) {
            this.projectTypeList.setSelectedIndex(selectIndex);
        }
    }

    public void clearLists() {
        this.projectTypeList.removeAll();
        this.subtypeList.removeAll();
        if (this.projectTypeListModel != null) {
            this.projectTypeListModel.removeAllElements();
        }
        if (this.subTypeListModel != null) {
            this.subTypeListModel.removeAllElements();
        }
    }

    public void setInitialProjectInfo(ProjectInfo info) {
        boolean projectInfoChanged = true;
        if (this.initialProjectInfo != null && this.initialProjectInfo.type.getId().equals(info.type.getId()) && this.initialProjectInfo.language.getId().equals(info.language.getId())) {
            projectInfoChanged = false;
        }
        this.initialProjectInfo = info;
        if (info == null) {
            return;
        }
        if (projectInfoChanged && this.projectTypes != null) {
            Set<String> keys = this.projectTypes.keySet();
            int i = 0;
            int selectIndex = -1;
            for (String s : keys) {
                ProjectTypeInfo anInfo = this.projectTypes.get(s);
                if (anInfo.getId().equals(this.initialProjectInfo.type.getId())) {
                    selectIndex = i;
                    break;
                }
                ++i;
            }
            this.projectTypeList.setSelectedIndex(selectIndex);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.chooseProjectTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Choose the project type:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = this.subtypeLabel;
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(false);
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.preferencesLabel = jLabel = new JLabel();
        jLabel.setText("Control the project types shown in the table:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = this.manageTemplateSourcesLink;
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 0, new Dimension(-1, 200), new Dimension(-1, 200), null));
        JList<ProjectTypeInfo> jList = this.projectTypeList;
        jList.setSelectionMode(0);
        jScrollPane.setViewportView(jList);
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel.add((Component)jScrollPane2, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JList<ProjectTypeInfo.ProjectSubtypeInfo> jList2 = this.subtypeList;
        jList2.setSelectionMode(0);
        jScrollPane2.setViewportView(jList2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private static class ProjectTypeListCellRenderer<P>
    extends DefaultListCellRenderer {
        private ProjectTypeListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object o, int i, boolean b, boolean b1) {
            Component comp = super.getListCellRendererComponent(jList, o, i, b, b1);
            ProjectTypeInfo projectTypeInfo = (ProjectTypeInfo)o;
            String id = projectTypeInfo.getId();
            this.setText(ProjectType.getDisplayName(id));
            if (id.equals(ProjectType.TYPE_LIBERTY.getId())) {
                this.setIcon(IconCache.getCachedIcon("/icons/themeless/project-types/microprofile.svg"));
            } else if (id.equals(ProjectType.TYPE_SPRING.getId())) {
                this.setIcon(IconCache.getCachedIcon("/icons/themeless/project-types/spring.svg"));
            } else if (id.equals(ProjectType.TYPE_NODEJS.getId())) {
                this.setIcon(IconCache.getCachedIcon("/icons/themeless/project-types/nodejs.svg"));
            } else if (id.equals(ProjectType.TYPE_SWIFT.getId())) {
                this.setIcon(IconCache.getCachedIcon("/icons/themeless/project-types/swift.svg"));
            } else if (id.equals(ProjectType.TYPE_DOCKER.getId())) {
                this.setIcon(IconCache.getCachedIcon("/icons/themeless/project-types/generic.svg"));
            } else {
                this.setIcon(IconCache.getCachedIcon("/icons/themeless/project-types/generic.svg"));
            }
            return comp;
        }
    }

    private static class SubTypeListCellRenderer<P>
    extends DefaultListCellRenderer {
        private SubTypeListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object o, int i, boolean b, boolean b1) {
            Component comp = super.getListCellRendererComponent(jList, o, i, b, b1);
            String label = ((ProjectTypeInfo.ProjectSubtypeInfo)o).label;
            this.setText(ProjectLanguage.getDisplayName(label));
            return comp;
        }
    }
}

