/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.ui.treeStructure.Tree;
import javax.swing.tree.TreePath;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tasks.RefreshTask;
import org.eclipse.codewind.intellij.ui.tree.CodewindTreeModel;
import org.jetbrains.annotations.NotNull;

public class RefreshAction
extends AnAction {
    public RefreshAction() {
        super(CodewindUIBundle.message("ACTION_REFRESH", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object data;
        if (e == null) {
            RefreshAction.$$$reportNull$$$0(0);
        }
        if (!((data = e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) instanceof Tree)) {
            Logger.log("unrecognized component for RefreshAction: " + data);
            System.out.println("*** unrecognized component for RefreshAction: " + data);
            return;
        }
        Tree tree = (Tree)data;
        TreePath treePath = tree.getSelectionPath();
        if (treePath == null) {
            Logger.log("no selection for RefreshAction: " + data);
            System.out.println("*** no selection for RefreshAction: " + data);
            return;
        }
        Object node = treePath.getLastPathComponent();
        ProgressManager.getInstance().run((Task)new RefreshTask(node, tree));
        CodewindTreeModel model = (CodewindTreeModel)((Object)tree.getModel());
        if (node instanceof ConnectionManager) {
            model.updateAll();
            return;
        }
        if (node instanceof CodewindConnection) {
            CodewindConnection connection = (CodewindConnection)node;
            model.updateConnection(connection);
            return;
        }
        if (node instanceof CodewindApplication) {
            model.updateApplication((CodewindApplication)node);
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/actions/RefreshAction", "actionPerformed"));
    }
}

