/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.toolwindow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.content.Content;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.FileUtil;
import org.eclipse.codewind.intellij.core.IUpdateHandler;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.core.launch.CoreUiUtil;
import org.jetbrains.annotations.SystemIndependent;

public class UpdateHandler
implements IUpdateHandler {
    private static final UpdateHandler INSTANCE = new UpdateHandler();
    private static final HashMap<AppKey, AppUpdateListener> appListeners = new HashMap();

    public static UpdateHandler getInstance() {
        return INSTANCE;
    }

    private UpdateHandler() {
    }

    @Override
    public void updateAll() {
        this.updateApps();
    }

    @Override
    public void updateConnection(CodewindConnection connection) {
        this.updateApps(connection);
    }

    private void updateApps() {
        ConnectionManager.getManager().activeConnections().forEach(this::updateApps);
    }

    private void updateApps(CodewindConnection conn) {
        if (conn != null) {
            conn.getApps().forEach(this::updateApplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateApplication(CodewindApplication application) {
        HashMap<AppKey, AppUpdateListener> hashMap = appListeners;
        synchronized (hashMap) {
            Set<AppKey> appKeys = appListeners.keySet();
            for (AppKey key : appKeys) {
                AppUpdateListener listener;
                if (!application.connection.getConid().equals(key.connectionId) || !application.projectID.equals(key.projectId) || (listener = appListeners.get(key)) == null) continue;
                listener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(List<CodewindApplication> apps) {
        HashMap<AppKey, AppUpdateListener> hashMap = appListeners;
        synchronized (hashMap) {
            for (CodewindApplication application : apps) {
                Set<AppKey> appKeys = appListeners.keySet();
                for (AppKey key : appKeys) {
                    AppUpdateListener listener;
                    if (!application.connection.getConid().equals(key.connectionId) || !application.projectID.equals(key.projectId) || (listener = appListeners.get(key)) == null) continue;
                    listener.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplication(CodewindApplication application) {
        HashMap<AppKey, AppUpdateListener> hashMap = appListeners;
        synchronized (hashMap) {
            Set<AppKey> appKeys = appListeners.keySet();
            for (AppKey key : appKeys) {
                AppUpdateListener listener;
                if (!application.connection.getConid().equals(key.connectionId) || !application.projectID.equals(key.projectId) || (listener = appListeners.get(key)) == null) continue;
                listener.remove();
            }
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            Project currentProject = null;
            for (Project project : openProjects) {
                @SystemIndependent String basePath = project.getBasePath();
                if (!FileUtil.isSamePath(application.fullLocalPath.toAbsolutePath().toString(), basePath)) continue;
                currentProject = project;
                break;
            }
            if (currentProject == null) {
                return;
            }
            CoreUiUtil.clearRunConfig(currentProject, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppUpdateListener(Content content, String connectionId, String projectID, AppUpdateListener listener) {
        HashMap<AppKey, AppUpdateListener> hashMap = appListeners;
        synchronized (hashMap) {
            appListeners.put(new AppKey(content, connectionId, projectID), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppUpdateListener getAppUpdateListener(Content content, String connectionId, String projectID) {
        HashMap<AppKey, AppUpdateListener> hashMap = appListeners;
        synchronized (hashMap) {
            Set<AppKey> appKeys = appListeners.keySet();
            for (AppKey key : appKeys) {
                if (key.content != content || !key.connectionId.equals(connectionId) || !key.projectId.equals(projectID)) continue;
                return appListeners.get(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppUpdateListener(Content content, String connectionId, String projectID) {
        HashMap<AppKey, AppUpdateListener> hashMap = appListeners;
        synchronized (hashMap) {
            Set<AppKey> appKeys = appListeners.keySet();
            ArrayList<AppKey> keysToRemove = new ArrayList<AppKey>();
            for (AppKey key : appKeys) {
                AppUpdateListener listener = appListeners.get(key);
                if (content != key.content || !key.connectionId.equals(connectionId) || !key.projectId.equals(projectID) || listener == null) continue;
                listener.remove();
                keysToRemove.add(key);
            }
            for (AppKey key : keysToRemove) {
                appListeners.remove(key);
            }
        }
    }

    private static class AppKey {
        public final String connectionId;
        public final String projectId;
        public final Content content;

        public AppKey(Content content, String connectionId, String projectID) {
            this.connectionId = connectionId;
            this.projectId = projectID;
            this.content = content;
        }
    }

    public static interface AppUpdateListener {
        public void update();

        public void remove();
    }
}

