/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.constants.AppStatus;
import org.eclipse.codewind.intellij.ui.actions.AbstractProjectDependentAction;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tasks.RestartRunModeTask;
import org.jetbrains.annotations.NotNull;

public class RestartRunModeAction
extends AbstractProjectDependentAction {
    public RestartRunModeAction() {
        super(CodewindUIBundle.message("RestartInRunMode", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RestartRunModeAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        CodewindApplication app = this.getSelection(e);
        if (app != null && app.isAvailable() && app.getProjectCapabilities().canRestart()) {
            e.getPresentation().setEnabled(app.getAppStatus() == AppStatus.STARTED || app.getAppStatus() == AppStatus.STARTING);
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        boolean isCurrentOpenedProject;
        Project project;
        CodewindApplication application;
        if (e == null) {
            RestartRunModeAction.$$$reportNull$$$0(1);
        }
        if ((application = this.getSelection(e)) != null && (project = e.getProject()) != null && (isCurrentOpenedProject = this.openProjectInIde(application, project))) {
            ProgressManager.getInstance().run((Task)this.getTaskToRun(application, project));
        }
    }

    @Override
    protected Task.Backgroundable getTaskToRun(CodewindApplication application, Project project) {
        return new RestartRunModeTask(application, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/actions/RestartRunModeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

