/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.templates;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.ThrowableComputable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.codewind.intellij.core.HttpUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.templates.AbstractAddTemplateSourceWizardStep;
import org.eclipse.codewind.intellij.ui.templates.AddTemplateSourceWizardModel;
import org.eclipse.codewind.intellij.ui.templates.DetailsStep;
import org.eclipse.codewind.intellij.ui.templates.RepoEntry;
import org.eclipse.codewind.intellij.ui.templates.form.UrlForm;
import org.eclipse.codewind.intellij.ui.wizard.CodewindCommitStepException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlStep
extends AbstractAddTemplateSourceWizardStep {
    public static String STEP_ID = "UrlStep";
    private UrlForm form;

    public UrlStep(Project project, CodewindConnection connection, AddTemplateSourceWizardModel wizardModel) {
        super(null);
        this.project = project;
        this.connection = connection;
        this.wizardModel = wizardModel;
        this.nextStepId = DetailsStep.STEP_ID;
    }

    @NotNull
    public Object getStepId() {
        String string = STEP_ID;
        if (string == null) {
            UrlStep.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Object getNextStepId() {
        return this.nextStepId;
    }

    @Nullable
    public Object getPreviousStepId() {
        return null;
    }

    public boolean isComplete() {
        return this.form.isComplete();
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
    }

    public JComponent getComponent() {
        if (this.form == null) {
            this.form = new UrlForm(this.project, this.connection, false, this.wizardModel.getTemplateSourceURL());
            this.form.addListener(this);
            this.form.getAuthForm().addListener(this);
        }
        return this.form.getContentPane();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireStateChanged();
    }

    @Override
    protected void onStepEntering() {
    }

    @Override
    protected void onStepLeaving() throws CodewindCommitStepException {
        final String urlValue = this.form.getTemplateSourceUrl();
        JTextField urlTextField = this.form.getTemplateSourceTextField();
        if (urlTextField.getText().length() == 0) {
            throw new CodewindCommitStepException(CodewindUIBundle.message("AddRepoDialogInvalidUrlTitle", new Object[0]), CodewindUIBundle.message("AddRepoDialogInvalidUrlMsg", new Object[0]), urlTextField);
        }
        try {
            if (urlValue != null) {
                URI uRI = new URI(urlValue);
            }
        }
        catch (URISyntaxException e) {
            throw new CodewindCommitStepException(CodewindUIBundle.message("AddRepoDialogInvalidUrlTitle", new Object[0]), CodewindUIBundle.message("AddRepoDialogInvalidUrlMsg", new Object[0]), urlTextField);
        }
        this.wizardModel.setUrlValue(this.getTemplateSourceUrl());
        this.wizardModel.setAuthInfo(this.form.getAuthInfo());
        if (!this.wizardModel.isEdit()) {
            List<RepoEntry> repoEntries = this.wizardModel.getRepoEntries();
            for (RepoEntry entry : repoEntries) {
                if (!this.form.getTemplateSourceUrl().equals(entry.url)) continue;
                throw new CodewindCommitStepException(CodewindUIBundle.message("AddRepoDialogInvalidUrlTitle", new Object[0]), CodewindUIBundle.message("AddRepoDialogDuplicateUrlError", new Object[0]), this.form.getTemplateSourceTextField());
            }
        }
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Object, Exception>(){

                public Object compute() throws Exception {
                    EmptyProgressIndicator monitor = new EmptyProgressIndicator();
                    HttpUtil.HttpResult result = HttpUtil.get(new URI(urlValue), UrlStep.this.form.getAuthInfo());
                    if (!result.isGoodResponse) {
                        String errorMsg = result.error;
                        if (errorMsg == null || errorMsg.trim().isEmpty()) {
                            errorMsg = CodewindUIBundle.message("AddRepoDialogTestFailedDefaultMsg", result.responseCode);
                        }
                        throw new InvocationTargetException(new IOException(errorMsg));
                    }
                    return result;
                }
            }, CodewindUIBundle.message("AddRepoDialogTestTaskLabel", urlValue), true, this.project);
        }
        catch (Exception e) {
            String msg = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getCause().toString() : e.toString();
            throw new CodewindCommitStepException(CodewindUIBundle.message("AddRepoDialogTestFailedTitle", new Object[0]), CodewindUIBundle.message("AddRepoDialogTestFailedError", msg), urlTextField);
        }
    }

    @Override
    protected void postDoNextStep() {
    }

    @Override
    public ValidationInfo doValidate() {
        return this.form.doValidate();
    }

    public String getTemplateSourceUrl() {
        return this.form.getTemplateSourceUrl();
    }

    String getUsername() {
        return this.form.getUsername();
    }

    String getPassword() {
        return this.form.getPassword();
    }

    String getToken() {
        return this.form.getToken();
    }

    @Override
    public void addListener(ChangeListener listener) {
        this.form.addListener(listener);
        this.form.getAuthForm().addListener(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/eclipse/codewind/intellij/ui/templates/UrlStep", "getStepId"));
    }
}

