/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.form;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ui.HyperlinkAdapter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.eclipse.codewind.intellij.core.Logger;

public class WidgetUtils {
    public static JTextArea createJTextArea(String textValue) {
        JTextArea textArea = new JTextArea();
        JTextField textField = new JTextField();
        textArea.setBorder(BorderFactory.createCompoundBorder(textField.getBorder(), BorderFactory.createEmptyBorder(3, 6, 3, 6)));
        textArea.setSelectedTextColor(textField.getSelectedTextColor());
        textArea.setFont(textField.getFont());
        textArea.setOpaque(false);
        textArea.setText(textValue);
        textArea.setRequestFocusEnabled(true);
        return textArea;
    }

    public static JTextPane createTextPane(String textValue, boolean showBorder) {
        JTextPane textPane = new JTextPane();
        JTextField tf = new JTextField();
        textPane.setContentType("text/string");
        textPane.setEditable(false);
        textPane.setOpaque(false);
        if (showBorder) {
            textPane.setBorder(BorderFactory.createCompoundBorder(tf.getBorder(), BorderFactory.createEmptyBorder(3, 6, 3, 6)));
        }
        textPane.setFont(tf.getFont());
        textPane.setSelectedTextColor(tf.getSelectedTextColor());
        textPane.setSelectionColor(tf.getSelectionColor());
        textPane.setText(textValue);
        textPane.setRequestFocusEnabled(true);
        textPane.setFocusable(true);
        return textPane;
    }

    public static JLabel createHyperlinkUsingLabel(String urlValue) {
        final JLabel hyperlink = new JLabel(urlValue);
        hyperlink.setForeground(Color.BLUE.darker());
        hyperlink.setCursor(new Cursor(12));
        hyperlink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                try {
                    BrowserLauncher.getInstance().browse(new URI(hyperlink.getText()));
                }
                catch (URISyntaxException e) {
                    Logger.logTrace(e);
                }
            }
        });
        JTextField tf = new JTextField();
        hyperlink.setBorder(BorderFactory.createCompoundBorder(tf.getBorder(), BorderFactory.createEmptyBorder(3, 6, 3, 6)));
        return hyperlink;
    }

    public static JTextPane createHyperlinkUsingTextPane(String urlValue, boolean showBorder) {
        JTextPane hyperlink = new JTextPane();
        JTextField tf = new JTextField();
        if (urlValue.length() == 0) {
            hyperlink.setContentType("text/string");
        } else {
            hyperlink.setContentType("text/html");
        }
        hyperlink.setEditable(false);
        hyperlink.setOpaque(false);
        if (showBorder) {
            hyperlink.setBorder(BorderFactory.createCompoundBorder(tf.getBorder(), BorderFactory.createEmptyBorder(3, 6, 3, 6)));
        }
        hyperlink.setFont(tf.getFont());
        hyperlink.setSelectedTextColor(tf.getSelectedTextColor());
        hyperlink.setSelectionColor(tf.getSelectionColor());
        hyperlink.setText(urlValue);
        hyperlink.setRequestFocusEnabled(true);
        hyperlink.setFocusable(true);
        InputMap inputMap = hyperlink.getInputMap(2);
        KeyStroke goKey = KeyStroke.getKeyStroke(71, 2);
        inputMap.put(goKey, "activate-link-action");
        hyperlink.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent event) {
                try {
                    BrowserLauncher.getInstance().browse(event.getURL().toURI());
                }
                catch (Exception e) {
                    Logger.logTrace(e);
                }
            }
        });
        return hyperlink;
    }

    public static JEditorPane createHyperlink(@Nonnull String urlValue) {
        JEditorPane editorPane = new JEditorPane();
        JTextField tf = new JTextField();
        if (urlValue.length() == 0) {
            editorPane.setContentType("text/string");
        } else {
            editorPane.setContentType("text/html");
        }
        editorPane.setEditable(false);
        editorPane.setOpaque(false);
        editorPane.setBorder(BorderFactory.createCompoundBorder(tf.getBorder(), BorderFactory.createEmptyBorder(3, 6, 3, 6)));
        editorPane.setSelectedTextColor(tf.getSelectedTextColor());
        editorPane.setFont(tf.getFont());
        editorPane.setText(urlValue);
        InputMap inputMap = editorPane.getInputMap(2);
        KeyStroke goKey = KeyStroke.getKeyStroke(71, 2);
        inputMap.put(goKey, "activate-link-action");
        editorPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent event) {
                try {
                    BrowserLauncher.getInstance().browse(event.getURL().toURI());
                }
                catch (Exception e) {
                    Logger.logTrace(e);
                }
            }
        });
        return editorPane;
    }

    public static String getTextValue(JTextField text) {
        return text.getText() == null || text.getText().trim().isEmpty() ? "" : text.getText().trim();
    }

    public static String getPassword(JPasswordField passwordField) {
        char[] password = passwordField.getPassword();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < password.length; ++i) {
            sb.append(password[i]);
        }
        return sb.toString();
    }
}

