/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.codewind.filewatchers.core.FWLogger;

public class PathUtils {
    private static final FWLogger log = FWLogger.getInstance();

    private static boolean isWindowsAbsolutePath(String absolutePath) {
        if (absolutePath.length() < 2) {
            return false;
        }
        char char0 = absolutePath.charAt(0);
        if (!Character.isLetter(char0)) {
            return false;
        }
        return absolutePath.charAt(1) == ':';
    }

    public static String normalizeDriveLetter(String absolutePath) {
        if (absolutePath.contains("\\")) {
            throw new IllegalArgumentException("This function does not support Windows-style paths.");
        }
        if (absolutePath.length() < 2) {
            return absolutePath;
        }
        if (!absolutePath.startsWith("/")) {
            throw new IllegalArgumentException("Path should begin with forward slash: " + absolutePath);
        }
        char char0 = absolutePath.charAt(0);
        char char1 = absolutePath.charAt(1);
        if (absolutePath.length() == 2) {
            if (char0 == '/' && Character.isLetter(char1) && Character.isUpperCase(char1)) {
                return "/" + Character.toLowerCase(char1);
            }
            return absolutePath;
        }
        char char2 = absolutePath.charAt(2);
        if (char0 == '/' && char2 == '/' && Character.isLetter(char1) && Character.isUpperCase(char1)) {
            return "/" + Character.toLowerCase(char1) + char2 + absolutePath.substring(3);
        }
        return absolutePath;
    }

    public static String convertFromWindowsDriveLetter(String absolutePath) {
        if (!PathUtils.isWindowsAbsolutePath(absolutePath)) {
            return absolutePath;
        }
        absolutePath = absolutePath.replace("\\", "/");
        char char0 = absolutePath.charAt(0);
        absolutePath = absolutePath.substring(2);
        absolutePath = "/" + Character.toLowerCase(char0) + absolutePath;
        return absolutePath;
    }

    public static String convertAbsoluteUnixStyleNormalizedPathToLocalFile(String str) {
        if (File.separator.equals("/")) {
            return str;
        }
        return PathUtils.convertAbsoluteUnixStyleNormalizedPathToLocalFile(str, true);
    }

    public static String convertAbsoluteUnixStyleNormalizedPathToLocalFile(String str, boolean isWindows) {
        if (!isWindows) {
            return str;
        }
        if (!str.startsWith("/")) {
            throw new IllegalArgumentException("Parameters must begin with slash");
        }
        if (str.length() <= 1) {
            throw new IllegalArgumentException("Cannot convert string with length of 0 or 1: " + str);
        }
        char driveLetter = str.charAt(1);
        if (!Character.isLetter(driveLetter)) {
            throw new IllegalArgumentException("Missing drive letter: " + str);
        }
        if (str.length() == 2) {
            return driveLetter + ":\\";
        }
        char secondSlash = str.charAt(2);
        if (secondSlash != '/') {
            throw new IllegalArgumentException("Invalid path format: " + str);
        }
        return driveLetter + ":\\" + str.substring(3).replace("/", "\\");
    }

    public static String stripTrailingSlash(String str) {
        while (str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static Optional<String> convertAbsolutePathWithUnixSeparatorsToProjectRelativePath(String path, String rootPath) {
        if (rootPath.contains("\\")) {
            throw new IllegalArgumentException("Forward slashes are not supported.");
        }
        if (!path.startsWith(rootPath = PathUtils.stripTrailingSlash(rootPath))) {
            log.logSevere("Watch event '" + path + "' does not match project path '" + rootPath + "'");
            return Optional.empty();
        }
        if ((path = path.replace(rootPath, "")).length() == 0) {
            path = "/";
        }
        return Optional.of(path);
    }

    public static String normalizePath(String pathParam) {
        String absPath = pathParam.replace("\\", "/");
        absPath = PathUtils.convertFromWindowsDriveLetter(absPath);
        absPath = PathUtils.normalizeDriveLetter(absPath);
        return PathUtils.stripTrailingSlash(absPath);
    }

    public static List<String> splitRelativeProjectPathIntoComponentPaths(String path) {
        ArrayList<String> result = new ArrayList<String>();
        String currPath = path;
        while (currPath.length() != 1) {
            result.add(currPath);
            int index = currPath.lastIndexOf("/");
            if (index <= 0) break;
            currPath = currPath.substring(0, index);
        }
        return result;
    }
}

