/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.templates;

import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.codewind.intellij.core.HttpUtil;
import org.eclipse.codewind.intellij.core.IAuthInfo;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.templates.AbstractAddTemplateSourceWizardStep;
import org.eclipse.codewind.intellij.ui.templates.AddTemplateSourceWizardModel;
import org.eclipse.codewind.intellij.ui.templates.UrlStep;
import org.eclipse.codewind.intellij.ui.templates.form.DetailsForm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class DetailsStep
extends AbstractAddTemplateSourceWizardStep {
    public static String STEP_ID = "DetailsStep";
    private DetailsForm form;
    public static final String DETAILS_FILE_NAME = "templates.json";
    public static final String NAME_KEY = "name";
    public static final String DESCRIPTION_KEY = "description";
    private String nameValue;
    private String descriptionValue;
    private String[] defaultValues = new String[2];

    public DetailsStep(Project project, CodewindConnection connection, AddTemplateSourceWizardModel wizardModel) {
        this(project, connection, wizardModel, wizardModel.getNameValue(), wizardModel.getDescriptionValue());
    }

    public DetailsStep(Project project, CodewindConnection connection, AddTemplateSourceWizardModel wizardModel, String nameValue, String descriptionValue) {
        super(null);
        this.project = project;
        this.connection = connection;
        this.wizardModel = wizardModel;
        this.nextStepId = null;
        this.previousStepId = UrlStep.STEP_ID;
        this.nameValue = nameValue;
        this.descriptionValue = descriptionValue;
    }

    @NotNull
    public Object getStepId() {
        String string = STEP_ID;
        if (string == null) {
            DetailsStep.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Object getNextStepId() {
        return null;
    }

    @Nullable
    public Object getPreviousStepId() {
        return this.previousStepId;
    }

    public boolean isComplete() {
        return this.form.isComplete();
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
    }

    public JComponent getComponent() {
        if (this.form == null) {
            this.form = new DetailsForm(this.project, this.connection, this.nameValue, this.descriptionValue);
            this.form.addListener(this);
        }
        return this.form.getContentPane();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireStateChanged();
    }

    @Override
    protected void onStepEntering() {
        final IAuthInfo authInfo = this.wizardModel.getAuthInfo();
        this.descriptionValue = this.wizardModel.getDescriptionValue();
        this.nameValue = this.wizardModel.getNameValue();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    String urlValue = DetailsStep.this.wizardModel.getTemplateSourceURL();
                    URL repoUrl = new URL(urlValue);
                    String path = repoUrl.getPath();
                    path = path.substring(0, path.lastIndexOf("/") + 1) + DetailsStep.DETAILS_FILE_NAME;
                    URL detailsUrl = new URL(repoUrl.getProtocol(), repoUrl.getHost(), path);
                    HttpUtil.HttpResult result = HttpUtil.get(detailsUrl.toURI(), authInfo);
                    if (result.isGoodResponse && result.response != null && !result.response.isEmpty()) {
                        String description;
                        JSONObject jsonObj = new JSONObject(result.response);
                        String name = jsonObj.has(DetailsStep.NAME_KEY) ? jsonObj.getString(DetailsStep.NAME_KEY) : null;
                        String string = description = jsonObj.has(DetailsStep.DESCRIPTION_KEY) ? jsonObj.getString(DetailsStep.DESCRIPTION_KEY) : null;
                        if (name == null || name.isEmpty()) {
                            Logger.logDebug("Found the template source information but the name is null or empty: " + detailsUrl);
                        } else {
                            ((DetailsStep)DetailsStep.this).defaultValues[0] = name;
                            ((DetailsStep)DetailsStep.this).defaultValues[1] = description;
                            DetailsStep.this.form.setDefaultValues(DetailsStep.this.defaultValues);
                            if (DetailsStep.this.nameValue == null) {
                                DetailsStep.this.form.setNameValue(name);
                            } else {
                                DetailsStep.this.form.setNameValue(DetailsStep.this.nameValue);
                            }
                            if (DetailsStep.this.descriptionValue == null) {
                                DetailsStep.this.form.setDescriptionValue(description == null ? "" : description);
                            } else {
                                DetailsStep.this.form.setDescriptionValue(DetailsStep.this.descriptionValue);
                            }
                        }
                    } else {
                        Logger.logTrace("Got error code " + result.error + " trying to retrieve the template source details for url: " + detailsUrl + ", and error: " + result.error);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, CodewindUIBundle.message("AddRepoDialogAutoFillTaskLabel", new Object[0]), true, this.project);
    }

    @Override
    protected void onStepLeaving() {
    }

    @Override
    protected void postDoNextStep() {
    }

    @Override
    public ValidationInfo doValidate() {
        return null;
    }

    String getTemplateSourceName() {
        return this.form.getTemplateSourceName();
    }

    String getTemplateSourceDescription() {
        return this.form.getTemplateSourceDescription();
    }

    @Override
    public void addListener(ChangeListener listener) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/eclipse/codewind/intellij/ui/templates/DetailsStep", "getStepId"));
    }
}

