/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.module;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.codewind.intellij.core.CodewindManager;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.InstallStatus;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tasks.InstallCodewindTask;
import org.eclipse.codewind.intellij.ui.tasks.StartCodewindTask;
import org.eclipse.codewind.intellij.ui.tasks.UpgradeCodewindTask;

public class CustomOptionsStep
extends ModuleWizardStep {
    private final JPanel panel = new JPanel();
    private final JLabel label;
    private final JButton button;
    private boolean isStarted;

    public CustomOptionsStep() {
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.label = new JLabel();
        this.label.setAlignmentX(0.0f);
        this.panel.add(this.label);
        this.button = new JButton();
        this.panel.add(this.button);
        this.configurePage();
    }

    private void removeActionListeners(JButton button) {
        for (ActionListener listener : button.getActionListeners()) {
            button.removeActionListener(listener);
        }
    }

    private void configurePage() {
        try {
            CodewindManager manager = CodewindManager.getManager();
            manager.refreshInstallStatus();
            InstallStatus status = manager.getInstallStatus();
            if (status.isStarted()) {
                this.label.setVisible(false);
                this.button.setVisible(false);
                this.isStarted = true;
            } else if (status.isError()) {
                String msg = manager.getInstallerErrorMsg();
                if (msg == null) {
                    CodewindUIBundle.message("CodewindErrorMsg", new Object[0]);
                }
                String labelText = CodewindUIBundle.message("CodewindStatusError", msg);
                this.label.setText(labelText);
                this.button.setText(CodewindUIBundle.message("RefreshCodewindStatus", new Object[0]));
                this.removeActionListeners(this.button);
                this.button.addActionListener(e -> {
                    manager.refreshInstallStatus();
                    this.configurePage();
                });
            } else if (status.isInstalled()) {
                this.label.setText(CodewindUIBundle.message("CodewindNotStarted", new Object[0]));
                this.button.setText(CodewindUIBundle.message("StartCodewind", new Object[0]));
                this.removeActionListeners(this.button);
                this.button.addActionListener(e -> {
                    manager.refreshInstallStatus();
                    if (manager.getInstallStatus().isStarted()) {
                        CoreUtil.openDialog(CoreUtil.DialogType.INFO, CodewindUIBundle.message("CodewindLabel", new Object[0]), CodewindUIBundle.message("CodewindStarted", new Object[0]));
                    } else {
                        ProgressManager.getInstance().run((Task)new StartCodewindTask(this::onStart));
                    }
                });
            } else if (status.hasInstalledVersions()) {
                this.label.setText(CodewindUIBundle.message("CodewindNotInstalled", new Object[0]));
                this.button.setText(CodewindUIBundle.message("UpgradeCodewind", new Object[0]));
                this.removeActionListeners(this.button);
                this.button.addActionListener(e -> {
                    manager.refreshInstallStatus();
                    if (manager.getInstallStatus().isStarted()) {
                        CoreUtil.openDialog(CoreUtil.DialogType.INFO, CodewindUIBundle.message("CodewindLabel", new Object[0]), CodewindUIBundle.message("CodewindStarted", new Object[0]));
                    } else {
                        ProgressManager.getInstance().run((Task)new UpgradeCodewindTask(this::onStart));
                    }
                });
            } else {
                this.label.setText(CodewindUIBundle.message("CodewindNotInstalled", new Object[0]));
                this.button.setText(CodewindUIBundle.message("InstallCodewind", new Object[0]));
                this.removeActionListeners(this.button);
                this.button.addActionListener(e -> {
                    manager.refreshInstallStatus();
                    if (manager.getInstallStatus().isStarted()) {
                        CoreUtil.openDialog(CoreUtil.DialogType.INFO, CodewindUIBundle.message("CodewindLabel", new Object[0]), CodewindUIBundle.message("CodewindStarted", new Object[0]));
                    } else {
                        ProgressManager.getInstance().run((Task)new InstallCodewindTask(this::onStart));
                    }
                });
            }
        }
        catch (Exception e2) {
            Throwable cause = Logger.unwrap(e2);
            Logger.logWarning(cause);
        }
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updateDataModel() {
        CodewindManager.getManager().refreshInstallStatus();
    }

    public boolean validate() throws ConfigurationException {
        return this.isStarted;
    }

    private void onStart() {
        this.isStarted = true;
        this.button.setEnabled(false);
        String txt = "<html>" + CodewindUIBundle.message("CodewindStarted", new Object[0]) + "</html>";
        this.label.setText(txt);
    }
}

