/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.ui.treeStructure.Tree;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.tree.TreePath;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.ui.tasks.RefreshTask;
import org.eclipse.codewind.intellij.ui.tree.CodewindTreeModel;
import org.jetbrains.annotations.NotNull;

public class OpenApplicationAction
extends AnAction {
    public OpenApplicationAction() {
        super("Open Application");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Object data;
        if (e == null) {
            OpenApplicationAction.$$$reportNull$$$0(0);
        }
        if (!((data = e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) instanceof Tree)) {
            Logger.log("unrecognized component for OpenApplicationAction: " + data);
            System.out.println("*** unrecognized component for OpenApplicationAction: " + data);
            return;
        }
        Tree tree = (Tree)data;
        TreePath treePath = tree.getSelectionPath();
        if (treePath == null) {
            Logger.log("no selection for OpenApplicationAction: " + data);
            System.out.println("*** no selection for OpenApplicationAction: " + data);
            return;
        }
        Object node = treePath.getLastPathComponent();
        ProgressManager.getInstance().run((Task)new RefreshTask(node, tree));
        CodewindTreeModel model = (CodewindTreeModel)((Object)tree.getModel());
        if (node instanceof CodewindApplication) {
            CodewindApplication app = (CodewindApplication)node;
            URL rootURL = app.getRootUrl();
            if (rootURL != null) {
                URI rootURI = null;
                try {
                    rootURI = rootURL.toURI();
                    BrowserLauncher.getInstance().browse(rootURI);
                }
                catch (URISyntaxException use) {
                    Logger.log("Bad Application URL: " + rootURL);
                    System.out.println("*** Bad Application URL: " + rootURL);
                }
            }
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/actions/OpenApplicationAction", "actionPerformed"));
    }
}

