/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.AuthToken;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpUtil {
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 10000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 10000;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final X509TrustManager trustManager = HttpUtil.getTrustAllCertsManager();
    public static final SSLContext sslContext = HttpUtil.getTrustAllCertsContext(trustManager);
    public static final HostnameVerifier hostnameVerifier = HttpUtil.getHostnameVerifier();

    private HttpUtil() {
    }

    public static HttpResult get(URI uri) throws IOException {
        return HttpUtil.get(uri, null);
    }

    public static HttpResult get(URI uri, AuthToken auth) throws IOException {
        return HttpUtil.sendRequest("GET", uri, auth, null);
    }

    public static HttpResult get(URI uri, AuthToken auth, int connectTimeoutMS, int readTimeoutMS) throws IOException {
        return HttpUtil.sendRequest("GET", uri, auth, null, connectTimeoutMS, readTimeoutMS);
    }

    public static HttpResult post(URI uri, AuthToken auth, JSONObject payload) throws IOException {
        return HttpUtil.sendRequest("POST", uri, auth, payload, 10000, 10000);
    }

    public static HttpResult post(URI uri, AuthToken auth, JSONObject payload, int readTimeoutSeconds) throws IOException {
        return HttpUtil.sendRequest("POST", uri, auth, payload, 10000, readTimeoutSeconds * 1000);
    }

    public static HttpResult post(URI uri, AuthToken auth) throws IOException {
        return HttpUtil.sendRequest("POST", uri, auth, null);
    }

    public static HttpResult put(URI uri, AuthToken auth) throws IOException {
        return HttpUtil.sendRequest("PUT", uri, auth, null);
    }

    public static HttpResult put(URI uri, AuthToken auth, JSONObject payload) throws IOException {
        return HttpUtil.sendRequest("PUT", uri, auth, payload, 10000, 10000);
    }

    public static HttpResult put(URI uri, AuthToken auth, JSONObject payload, int readTimoutSeconds) throws IOException {
        return HttpUtil.sendRequest("PUT", uri, auth, payload, 10000, 10000);
    }

    public static HttpResult head(URI uri, AuthToken auth) throws IOException {
        return HttpUtil.sendRequest("HEAD", uri, auth, null);
    }

    public static HttpResult delete(URI uri, AuthToken auth) throws IOException {
        return HttpUtil.delete(uri, auth, null);
    }

    public static HttpResult delete(URI uri, AuthToken auth, JSONObject payload) throws IOException {
        return HttpUtil.sendRequest("DELETE", uri, auth, payload);
    }

    public static HttpResult sendRequest(String method, URI uri, AuthToken auth, JSONObject payload) throws IOException {
        return HttpUtil.sendRequest(method, uri, auth, payload, 10000, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult sendRequest(String method, URI uri, AuthToken auth, JSONObject payload, int connectTimeoutMS, int readTimeoutMS) throws IOException {
        HttpURLConnection connection = null;
        if (payload != null) {
            Logger.log("Making a " + method + " request on " + uri + " with payload: " + payload.toString());
        } else {
            Logger.log("Making a " + method + " request on " + uri);
        }
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod(method);
            connection.setConnectTimeout(connectTimeoutMS);
            connection.setReadTimeout(readTimeoutMS);
            HttpUtil.addAuthorization(connection, auth);
            if (payload != null) {
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                DataOutputStream payloadStream = new DataOutputStream(connection.getOutputStream());
                payloadStream.write(payload.toString().getBytes());
            }
            HttpResult httpResult = new HttpResult(connection);
            return httpResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static void addAuthorization(HttpURLConnection connection, AuthToken auth) {
        if (sslContext == null || auth == null || auth.getToken() == null || auth.getTokenType() == null || !(connection instanceof HttpsURLConnection)) {
            return;
        }
        connection.setRequestProperty("Authorization", auth.getTokenType() + " " + auth.getToken());
        ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
        ((HttpsURLConnection)connection).setHostnameVerifier(hostnameVerifier);
    }

    public static HttpResult patch(URI uri, JSONArray payload) throws IOException {
        Logger.log("PATCH " + uri);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload.toString());
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(uri.toURL()).patch(body).build();
        Response response = client.newCall(request).execute();
        return new HttpResult(uri, response);
    }

    private static X509TrustManager getTrustAllCertsManager() {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };
    }

    private static SSLContext getTrustAllCertsContext(X509TrustManager manager) {
        try {
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            context.init(new KeyManager[0], new TrustManager[]{manager}, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            Logger.logWarning("An error occurred creating a trust all certs context", e);
            return null;
        }
    }

    private static HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return true;
            }
        };
    }

    public static class HttpResult {
        public final int responseCode;
        public final boolean isGoodResponse;
        public final String response;
        public final String error;
        private final Map<String, List<String>> headerFields;

        public HttpResult(HttpURLConnection connection) throws IOException {
            this.responseCode = connection.getResponseCode();
            this.isGoodResponse = this.responseCode > 199 && this.responseCode < 300;
            this.headerFields = this.isGoodResponse ? connection.getHeaderFields() : null;
            InputStream eis = connection.getErrorStream();
            this.error = eis != null ? CoreUtil.readAllFromStream(eis) : null;
            if (!this.isGoodResponse) {
                Logger.logWarning("Received bad response code " + this.responseCode + " from " + connection.getURL() + " - Error:\n" + this.error);
                this.response = null;
            } else {
                InputStream is = connection.getInputStream();
                this.response = is != null ? CoreUtil.readAllFromStream(is) : null;
            }
        }

        public HttpResult(URI uri, Response httpResponse) throws IOException {
            this.responseCode = httpResponse.code();
            this.isGoodResponse = this.responseCode > 199 && this.responseCode < 300;
            this.headerFields = null;
            InputStream stream = httpResponse.body().byteStream();
            String content = null;
            if (stream != null) {
                content = CoreUtil.readAllFromStream(stream);
            }
            if (this.isGoodResponse) {
                this.response = content;
                this.error = null;
            } else {
                this.error = content;
                this.response = null;
            }
            if (!this.isGoodResponse) {
                Logger.logWarning("Received bad response code " + this.responseCode + " from " + uri + " - Error:\n" + content);
            }
        }

        public String getHeader(String key) {
            if (this.headerFields == null) {
                return null;
            }
            List<String> list = this.headerFields.get(key);
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
    }
}

