/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.launch;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.Component;
import javax.swing.JFrame;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CodewindIntellijApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.ui.debug.CodewindConfigurationType;

public class CoreUiUtil {
    public static void debug(Project project, CodewindApplication application) {
        String debugName;
        String projectName = project.getName();
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings configurationByTypeAndName = runManager.findConfigurationByTypeAndName(CodewindConfigurationType.ID, debugName = project.getName());
        if (configurationByTypeAndName == null) {
            configurationByTypeAndName = runManager.createConfiguration(debugName, CodewindConfigurationType.class);
            ConfigurationType configType = configurationByTypeAndName.getType();
            ConfigurationFactory configurationFactory = configType.getConfigurationFactories()[0];
            configurationByTypeAndName = runManager.createConfiguration(debugName, configurationFactory);
            configurationByTypeAndName.setTemporary(true);
        }
        ((CodewindIntellijApplication)application).setRunnerAndConfigurationSettings(configurationByTypeAndName);
        runManager.addConfiguration(configurationByTypeAndName, false);
        runManager.setSelectedConfiguration(configurationByTypeAndName);
        runManager.setTemporaryConfiguration(configurationByTypeAndName);
        RunnerAndConfigurationSettings runner = configurationByTypeAndName;
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)runner.getConfiguration();
        remoteConfiguration.setAllowRunningInParallel(false);
        remoteConfiguration.PORT = String.valueOf(application.getDebugPort());
        remoteConfiguration.HOST = application.host;
        remoteConfiguration.setModuleName(projectName);
        CoreUtil.invokeLater(() -> {
            Component mostRecentFocusOwner;
            runner.setActivateToolWindowBeforeRun(true);
            ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunnerAndConfigurationSettings)runner);
            if (builder != null) {
                ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
            } else {
                try {
                    builder = ExecutionEnvironmentBuilder.create((Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunnerAndConfigurationSettings)runner);
                    ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
                }
                catch (Exception e) {
                    Logger.log(e);
                }
            }
            JFrame frame = WindowManager.getInstance().getFrame(project);
            if (frame != null && (mostRecentFocusOwner = frame.getMostRecentFocusOwner()) != null) {
                IdeFocusManager.getInstance((Project)project).requestFocus(mostRecentFocusOwner, true);
            }
        });
    }

    public static void clearRunConfig(Project project, RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        ContentManager contentManager;
        Content content;
        ProcessHandler[] runningProcesses;
        RunnerAndConfigurationSettings configurationByTypeAndName;
        String projectName = project.getName();
        RunManager runManager = RunManager.getInstance((Project)project);
        if (runnerAndConfigurationSettings != null) {
            runManager.removeConfiguration(runnerAndConfigurationSettings);
        }
        if ((configurationByTypeAndName = runManager.findConfigurationByTypeAndName(CodewindConfigurationType.ID, projectName)) != null && configurationByTypeAndName.isTemporary()) {
            runManager.removeConfiguration(configurationByTypeAndName);
        }
        for (ProcessHandler process : runningProcesses = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (process.isProcessTerminated() || process.isProcessTerminating()) continue;
            process.detachProcess();
        }
        ToolWindowManager toolWindowManager = null;
        if (!project.isDisposed()) {
            toolWindowManager = ToolWindowManager.getInstance((Project)project);
        }
        if (toolWindowManager == null) {
            return;
        }
        ToolWindow toolWindow = toolWindowManager.getToolWindow(ToolWindowId.DEBUG);
        if (toolWindow != null && (content = (contentManager = toolWindow.getContentManager()).findContent(project.getName())) != null) {
            CoreUtil.invokeLater(() -> contentManager.removeContent(content, true));
        }
    }
}

