/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.WindowManager;
import java.nio.file.Path;
import javax.swing.JFrame;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.FileUtil;
import org.eclipse.codewind.intellij.ui.actions.AbstractApplicationAction;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tree.CodewindToolWindowHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public abstract class AbstractProjectDependentAction
extends AbstractApplicationAction {
    public AbstractProjectDependentAction(String text) {
        super(text);
    }

    protected boolean openProjectInIde(@NotNull CodewindApplication application, @NotNull Project project) {
        if (application == null) {
            AbstractProjectDependentAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractProjectDependentAction.$$$reportNull$$$0(1);
        }
        String basePath = project.getBasePath().toString();
        String targetLocalPath = application.fullLocalPath.toString();
        CodewindApplication appByLocation = application.getConnection().getAppByLocation(basePath);
        if (appByLocation != application) {
            Project[] openedProjects = ProjectManager.getInstance().getOpenProjects();
            for (int i = 0; i < openedProjects.length; ++i) {
                Project openedProject = openedProjects[i];
                @SystemIndependent String openedProjectPath = openedProject.getBasePath();
                if (!FileUtil.isSamePath(openedProjectPath, targetLocalPath)) continue;
                Project targetOpenedProject = openedProject;
                JFrame frame = WindowManager.getInstance().getFrame(targetOpenedProject);
                if (frame != null) {
                    CoreUtil.invokeLater(() -> {
                        int rc = CoreUtil.showYesNoDialog(CodewindUIBundle.message("ProjectIsOpenedInAnotherWindowTitle", new Object[0]), CodewindUIBundle.message("ProjectIsOpenedInAnotherWindowMsg", new Object[0]));
                        if (rc == 0) {
                            frame.setVisible(true);
                            WindowManager.getInstance().suggestParentWindow(targetOpenedProject);
                            Task.Backgroundable task = this.getTaskToRun(application, targetOpenedProject);
                            ProgressManager.getInstance().run((Task)task);
                        }
                    });
                }
                return false;
            }
            CoreUtil.invokeLater(() -> {
                Project targetProject;
                int rc = CoreUtil.showYesNoDialog(CodewindUIBundle.message("ProjectMustBeOpenedToDebugTitle", new Object[0]), CodewindUIBundle.message("ProjectMustBeOpenedToDebugMessage", new Object[0]));
                if (rc == 0 && (targetProject = ProjectUtil.openOrImport((Path)application.fullLocalPath, (Project)project, (boolean)false)) != null) {
                    CodewindToolWindowHelper.openWindow(targetProject);
                    Task.Backgroundable task = this.getTaskToRun(application, targetProject);
                    ProgressManager.getInstance().run((Task)task);
                }
            });
            return false;
        }
        return true;
    }

    protected abstract Task.Backgroundable getTaskToRun(CodewindApplication var1, Project var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "application";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/eclipse/codewind/intellij/ui/actions/AbstractProjectDependentAction";
        objectArray[2] = "openProjectInIde";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

