/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import java.util.Arrays;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Logger {
    @NotNull
    private static com.intellij.openapi.diagnostic.Logger getLogger() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length < 2) {
            com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance((String)"#org.eclipse.codewind");
            if (logger == null) {
                Logger.$$$reportNull$$$0(0);
            }
            return logger;
        }
        Stream<StackTraceElement> stream = Arrays.stream(stackTrace, 2, stackTrace.length);
        String category = stream.map(StackTraceElement::getClassName).filter(className -> !className.equals(Logger.class.getName())).findFirst().map(name -> "#" + name).orElse("#org.eclipse.codewind");
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance((String)category);
        if (logger == null) {
            Logger.$$$reportNull$$$0(1);
        }
        return logger;
    }

    @NotNull
    private static com.intellij.openapi.diagnostic.Logger getGeneralLogger() {
        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance((String)"#org.eclipse.codewind");
        if (logger == null) {
            Logger.$$$reportNull$$$0(2);
        }
        return logger;
    }

    @Nullable
    private static String getCaller() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length < 2) {
            return null;
        }
        Stream<StackTraceElement> stream = Arrays.stream(stackTrace, 2, stackTrace.length);
        String caller = stream.map(StackTraceElement::getClassName).filter(className -> !className.equals(Logger.class.getName())).findFirst().orElse(null);
        return caller;
    }

    private static String getPrefixedMessage(String caller, String msg) {
        return caller != null ? caller + " - " + msg : msg;
    }

    public static void logDebug(String msg) {
        com.intellij.openapi.diagnostic.Logger logger = Logger.getGeneralLogger();
        if (logger.isDebugEnabled()) {
            String caller = Logger.getCaller();
            logger.debug(Logger.getPrefixedMessage(caller, msg));
        }
    }

    public static void logDebug(String msg, Throwable t) {
        com.intellij.openapi.diagnostic.Logger logger = Logger.getGeneralLogger();
        if (logger.isDebugEnabled()) {
            String caller = Logger.getCaller();
            logger.debug(Logger.getPrefixedMessage(caller, msg), t);
        }
    }

    public static void logTrace(String msg) {
        com.intellij.openapi.diagnostic.Logger logger = Logger.getGeneralLogger();
        if (logger.isTraceEnabled()) {
            String caller = Logger.getCaller();
            logger.trace(Logger.getPrefixedMessage(caller, msg));
        }
    }

    public static void logTrace(Throwable t) {
        com.intellij.openapi.diagnostic.Logger logger = Logger.getGeneralLogger();
        if (logger.isTraceEnabled()) {
            logger.trace(t);
        }
    }

    public static void logWarning(String msg) {
        Logger.getLogger().warn(msg);
    }

    public static void logWarning(String msg, Throwable t) {
        Logger.getLogger().warn(msg, t);
    }

    public static void logWarning(Throwable t) {
        Logger.getLogger().warn(t);
    }

    public static void log(String msg) {
        Logger.getLogger().info(msg);
    }

    public static void log(String msg, Throwable t) {
        Logger.getLogger().info(msg, t);
    }

    public static void log(Throwable t) {
        Logger.getLogger().info(t);
    }

    public static Throwable unwrap(Throwable error) {
        Throwable t = error;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/eclipse/codewind/intellij/core/Logger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneralLogger";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

