/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.ui.treeStructure.Tree;
import java.util.List;
import javax.swing.tree.TreePath;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.TemplateUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.templates.RepositoryManagementDialog;
import org.jetbrains.annotations.NotNull;

public class ManageReposAction
extends AnAction {
    public ManageReposAction() {
        super(CodewindUIBundle.message("RepoMgmtActionLabel", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ManageReposAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        CodewindConnection connection = this.getSelection(e);
        e.getPresentation().setEnabled(connection != null && connection.isConnected());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ManageReposAction.$$$reportNull$$$0(1);
        }
        CodewindConnection connection = this.getSelection(e);
        List[] repoListArray = new List[1];
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    EmptyProgressIndicator mon = new EmptyProgressIndicator();
                    repoListArray[0] = TemplateUtil.listTemplateSources(connection.getConid(), (ProgressIndicator)mon);
                }
                catch (Exception e1) {
                    Logger.logWarning("An error occurred trying to get the template sources for: " + connection.getName() + ": " + e1.getMessage());
                }
            }, CodewindUIBundle.message("RepoListTask", "connection"), false, e.getProject());
            RepositoryManagementDialog dialog = new RepositoryManagementDialog(e.getProject(), connection, repoListArray[0]);
            dialog.initForm();
            boolean rc = dialog.showAndGet();
            if (rc) {
                dialog.updateRepos();
            }
        }
        catch (Exception ex) {
            CoreUtil.openDialog(true, CodewindUIBundle.message("RepoListErrorTitle", new Object[0]), CodewindUIBundle.message("RepoListErrorMsg", ex));
        }
    }

    private CodewindConnection getSelection(@NotNull AnActionEvent e) {
        Object data;
        if (e == null) {
            ManageReposAction.$$$reportNull$$$0(2);
        }
        if (!((data = e.getData(PlatformDataKeys.CONTEXT_COMPONENT)) instanceof Tree)) {
            Logger.logDebug("Unrecognized component for : " + data);
            return null;
        }
        Tree tree = (Tree)data;
        TreePath treePath = tree.getSelectionPath();
        if (treePath == null) {
            Logger.logDebug("No selection path for ManageReposAction: " + tree);
            return null;
        }
        Object node = treePath.getLastPathComponent();
        if (!(node instanceof CodewindConnection)) {
            return null;
        }
        return (CodewindConnection)node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/actions/ManageReposAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

