/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tree;

import com.intellij.ui.tree.BaseTreeModel;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.IUpdateHandler;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;

public class CodewindTreeModel
extends BaseTreeModel<Object>
implements IUpdateHandler {
    private static final CodewindTreeModel INSTANCE = new CodewindTreeModel();
    private Object root = ConnectionManager.getManager();

    public List<? extends Object> getChildren(Object parent) {
        if (parent instanceof ConnectionManager) {
            return this.getChildren((ConnectionManager)parent);
        }
        if (parent instanceof CodewindConnection) {
            return this.getChildren((CodewindConnection)parent);
        }
        return Collections.emptyList();
    }

    private List<CodewindConnection> getChildren(ConnectionManager manager) {
        return manager.activeConnections();
    }

    private List<CodewindApplication> getChildren(CodewindConnection connection) {
        return connection.getSortedApps();
    }

    public Object getRoot() {
        return this.root;
    }

    @Override
    public void updateAll() {
        this.treeStructureChanged(new TreePath(this.getRoot()), new int[0], new Object[0]);
    }

    @Override
    public void updateConnection(CodewindConnection connection) {
        int index = this.getChildren(this.getRoot()).indexOf(connection);
        if (index >= 0) {
            TreePath path = CodewindTreeModel.treePathFrom(this.getRoot(), connection);
            this.treeStructureChanged(path, new int[0], new Object[0]);
        } else {
            TreePath path = CodewindTreeModel.treePathFrom(this.getRoot());
            this.treeStructureChanged(path, new int[0], new Object[0]);
        }
    }

    @Override
    public void updateApplication(CodewindApplication application) {
        TreePath path = CodewindTreeModel.treePathFrom(this.getRoot(), application.getConnection());
        int index = this.getChildren(application.getConnection()).indexOf(application);
        if (index >= 0) {
            try {
                this.treeNodesChanged(path, new int[]{index}, new Object[]{application});
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.treeStructureChanged(path, new int[0], new Object[0]);
            }
        } else {
            this.treeStructureChanged(path, new int[0], new Object[0]);
        }
    }

    @Override
    public void removeConnection(List<CodewindApplication> apps) {
        this.treeStructureChanged(new TreePath(this.getRoot()), new int[0], new Object[0]);
    }

    @Override
    public void removeApplication(CodewindApplication application) {
        this.updateConnection(application.getConnection());
    }

    private static TreePath treePathFrom(Object ... objects) {
        return new TreePath(objects);
    }

    public static CodewindTreeModel getInstance() {
        return INSTANCE;
    }
}

