/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.actions;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.ui.treeStructure.Tree;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.constants.AppStatus;
import org.eclipse.codewind.intellij.ui.actions.AbstractApplicationAction;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tasks.RefreshTask;
import org.jetbrains.annotations.NotNull;

public class OpenPerformanceDashboardAction
extends AbstractApplicationAction {
    public OpenPerformanceDashboardAction() {
        super(CodewindUIBundle.message("ActionOpenPerfDashboard", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenPerformanceDashboardAction.$$$reportNull$$$0(0);
        }
        CodewindApplication app = this.getSelection(e);
        e.getPresentation().setEnabled(app.isAvailable() && (app.getAppStatus() == AppStatus.STARTING || app.getAppStatus() == AppStatus.STARTED));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenPerformanceDashboardAction.$$$reportNull$$$0(1);
        }
        CodewindApplication app = this.getSelection(e);
        Tree tree = this.getTree(e);
        if (app != null && tree != null) {
            ProgressManager.getInstance().run((Task)new RefreshTask(app, tree));
            URL perfURL = app.getPerfDashboardUrl();
            if (perfURL != null) {
                URI perfURI = null;
                try {
                    perfURI = perfURL.toURI();
                    BrowserLauncher.getInstance().browse(perfURI);
                }
                catch (URISyntaxException use) {
                    Logger.log("Bad Performance Dashboard URL: " + perfURL);
                }
            }
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/actions/OpenPerformanceDashboardAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

