/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;
import org.eclipse.codewind.filewatchers.core.IPlatformWatchService;
import org.eclipse.codewind.filewatchers.core.PathFilter;
import org.eclipse.codewind.filewatchers.core.PathUtils;
import org.eclipse.codewind.filewatchers.core.ProjectToWatch;
import org.eclipse.codewind.filewatchers.core.WatchEventEntry;

public class JavaNioWatchService
implements IPlatformWatchService {
    private final Map<String, WatchedPath> watchedProjects_synch = new HashMap<String, WatchedPath>();
    private final List<IPlatformWatchService.IPlatformWatchListener> listeners_synch = new ArrayList<IPlatformWatchService.IPlatformWatchListener>();
    private static final FWLogger log = FWLogger.getInstance();
    private static final boolean DEBUG = log.isDebug();
    private AtomicBoolean disposed_synch = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IPlatformWatchService.IPlatformWatchListener gwl) {
        log.logDebug("Listener added to " + this.getClass().getSimpleName());
        List<IPlatformWatchService.IPlatformWatchListener> list = this.listeners_synch;
        synchronized (list) {
            this.listeners_synch.add(gwl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPath(File f, ProjectToWatch ptw) throws IOException {
        AtomicBoolean atomicBoolean = this.disposed_synch;
        synchronized (atomicBoolean) {
            if (this.disposed_synch.get()) {
                return;
            }
        }
        log.logInfo("Path '" + f.getPath() + "' added to " + this.getClass().getSimpleName());
        String key = ptw.getProjectId();
        Map<String, WatchedPath> map = this.watchedProjects_synch;
        synchronized (map) {
            WatchedPath value = this.watchedProjects_synch.get(key);
            if (value != null) {
                value.stopWatching();
            }
            this.watchedProjects_synch.put(key, new WatchedPath(f, ptw, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(File f, ProjectToWatch ptw) {
        AtomicBoolean atomicBoolean = this.disposed_synch;
        synchronized (atomicBoolean) {
            if (this.disposed_synch.get()) {
                return;
            }
        }
        String key = ptw.getProjectId();
        Map<String, WatchedPath> map = this.watchedProjects_synch;
        synchronized (map) {
            WatchedPath value = this.watchedProjects_synch.remove(key);
            if (value != null) {
                log.logInfo("Path '" + f.getPath() + "' removed from " + this.getClass().getSimpleName() + " for project " + ptw.getProjectId());
                value.stopWatching();
            } else {
                log.logError("Path '" + f.getPath() + "' attempted to be removed, but could not be found, from" + this.getClass().getSimpleName() + " for project " + ptw.getProjectId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AtomicBoolean atomicBoolean = this.disposed_synch;
        synchronized (atomicBoolean) {
            if (this.disposed_synch.get()) {
                return;
            }
            this.disposed_synch.set(true);
        }
        log.logInfo("dispose() called on " + this.getClass().getSimpleName());
        ArrayList<WatchedPath> toDispose = new ArrayList<WatchedPath>();
        Map<String, WatchedPath> map = this.watchedProjects_synch;
        synchronized (map) {
            toDispose.addAll(this.watchedProjects_synch.values());
            this.watchedProjects_synch.clear();
        }
        toDispose.forEach(e -> FilewatcherUtils.newThread(() -> e.stopWatching()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDebugState() {
        StringBuilder result = new StringBuilder();
        Map<String, WatchedPath> map = this.watchedProjects_synch;
        synchronized (map) {
            this.watchedProjects_synch.forEach((k, v) -> result.append("- " + k + " | " + v.getPathRoot().getPath() + "\n"));
        }
        return result.toString();
    }

    private static class WatchedPath {
        private final File pathRoot;
        private final String pathInNormalizedForm;
        private final WatchService watchService;
        private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
        private final Map<Path, Boolean> watchedPaths = new HashMap<Path, Boolean>();
        private final WatchedPathThread thread;
        private final JavaNioWatchService parent;
        private final FWLogger log = FWLogger.getInstance();
        private final PathFilter pathFilter;
        private final ProjectToWatch projectToWatch;
        private boolean threadActive = true;

        public WatchedPath(File pathRoot, ProjectToWatch projectToWatch, JavaNioWatchService parent) throws IOException {
            this.pathRoot = pathRoot;
            this.pathInNormalizedForm = PathUtils.normalizePath((String)pathRoot.getPath());
            this.parent = parent;
            this.projectToWatch = projectToWatch;
            this.pathFilter = new PathFilter(projectToWatch);
            Path path = pathRoot.toPath();
            this.watchService = path.getFileSystem().newWatchService();
            this.thread = new WatchedPathThread(this);
            this.thread.start();
        }

        private void addDirectory(Path path, List<File> filesFound) throws IOException {
            if (this.watchedPaths.containsKey(path)) {
                return;
            }
            String normalizedPath = PathUtils.normalizePath((String)path.toFile().getPath());
            String relativePath = PathUtils.convertAbsolutePathWithUnixSeparatorsToProjectRelativePath((String)normalizedPath, (String)this.pathInNormalizedForm).orElse(null);
            if (relativePath != null) {
                if (this.pathFilter.isFilteredOutByFilename(relativePath)) {
                    this.log.logDebug("Filtering out " + path + " due to filename");
                    return;
                }
                if (this.pathFilter.isFilteredOutByPath(relativePath)) {
                    this.log.logDebug("Filtering out " + path + " due to path.");
                    return;
                }
            }
            this.watchedPaths.put(path, true);
            WatchKey key = path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.keys.put(key, path);
            File[] farr = path.toFile().listFiles();
            if (farr == null) {
                this.log.logDebug("Added directory: " + path + " files found: " + farr + " " + path.toFile().exists());
                return;
            }
            for (File f : farr) {
                filesFound.add(f);
                if (!f.isDirectory()) continue;
                this.addDirectory(f.toPath(), filesFound);
            }
            this.log.logDebug("Added directory: " + path + " files found: " + farr.length);
        }

        private void addDirectoryRecursive(Path path, List<File> filesFound) throws IOException {
            if (DEBUG) {
                this.log.logDebug("Recursively adding directory: " + path);
            }
            this.addDirectory(path, filesFound);
            if (DEBUG) {
                this.log.logDebug("Completed recursively adding directory: " + path);
            }
        }

        public void stopWatching() {
            this.threadActive = false;
            FilewatcherUtils.newThread(() -> {
                try {
                    this.thread.interrupt();
                    this.watchService.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }

        private void eventLoopCatchAll() {
            if (!this.waitForWatchedPathSuccess()) {
                return;
            }
            while (this.threadActive) {
                try {
                    this.eventLoop();
                }
                catch (InterruptedException e) {
                    this.log.logDebug("Watch service interupted");
                    return;
                }
                catch (Exception e) {
                    if (e instanceof ClosedWatchServiceException && !this.threadActive) {
                        return;
                    }
                    this.log.logSevere("Unexpected event loop exception in " + this.getClass().getSimpleName(), (Throwable)e, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void eventLoop() throws InterruptedException {
            while (this.threadActive) {
                WatchKey key = this.watchService.take();
                Path dir = this.keys.get(key);
                if (dir == null) {
                    System.err.println("WatchKey not recognized!!");
                    continue;
                }
                List<Object> newEvents = new ArrayList();
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    Path name = (Path)event.context();
                    Path child = dir.resolve(name);
                    boolean isDirectory = Files.isDirectory(child, new LinkOption[0]);
                    WatchEventEntry we = null;
                    if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                        we = new WatchEventEntry(WatchEventEntry.EventType.CREATE, child, isDirectory);
                    } else if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                        we = new WatchEventEntry(WatchEventEntry.EventType.DELETE, child, isDirectory);
                    } else if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY && !Files.isDirectory(child, new LinkOption[0])) {
                        we = new WatchEventEntry(WatchEventEntry.EventType.MODIFY, child, isDirectory);
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        try {
                            if (Files.isDirectory(child, new LinkOption[0])) {
                                ArrayList<File> filesFound = new ArrayList<File>();
                                this.addDirectoryRecursive(child, filesFound);
                                for (File e2 : filesFound) {
                                    newEvents.add(new WatchEventEntry(WatchEventEntry.EventType.CREATE, e2.toPath(), e2.isDirectory()));
                                }
                            }
                        }
                        catch (IOException x) {
                            this.log.logSevere("Error during recursive directory add", (Throwable)x, null);
                        }
                    }
                    if (we == null) continue;
                    newEvents.add(we);
                }
                boolean valid = key.reset();
                if (!valid) {
                    this.keys.remove(key);
                    this.watchedPaths.remove(dir);
                    if (!dir.toFile().exists()) {
                        newEvents.add(new WatchEventEntry(WatchEventEntry.EventType.DELETE, dir, true));
                    }
                    if (this.keys.isEmpty()) {
                        if (this.pathRoot.exists()) {
                            this.log.logSevere("The watch service has nothing to watch, but the path root still exists. This should never happen. " + this.projectToWatch.getProjectId());
                        } else {
                            this.log.logInfo("The watch service has nothing to watch, so the thread is stopping in 30 seconds. " + this.projectToWatch.getProjectId());
                            FilewatcherUtils.newThread(() -> {
                                FilewatcherUtils.sleepIgnoreInterrupt((long)30000L);
                                this.log.logInfo("The watch service has nothing to watch, so the thread is now stopping: " + this.projectToWatch.getProjectId());
                                this.stopWatching();
                            });
                        }
                    }
                }
                if ((newEvents = newEvents.stream().filter(e -> {
                    String relativePath = PathUtils.convertAbsolutePathWithUnixSeparatorsToProjectRelativePath((String)e.getAbsolutePathWithUnixSeparators(), (String)this.pathInNormalizedForm).orElse(null);
                    return relativePath == null || !this.pathFilter.isFilteredOutByFilename(relativePath) && !this.pathFilter.isFilteredOutByPath(relativePath);
                }).collect(Collectors.toList())).size() <= 0) continue;
                ArrayList listeners = new ArrayList();
                List list = this.parent.listeners_synch;
                synchronized (list) {
                    listeners.addAll(this.parent.listeners_synch);
                }
                for (IPlatformWatchService.IPlatformWatchListener gwl : listeners) {
                    gwl.changeDetected(newEvents);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForWatchedPathSuccess() {
            long expireTimeInNanos = System.nanoTime() + TimeUnit.NANOSECONDS.convert(5L, TimeUnit.MINUTES);
            boolean watchSuccess = false;
            Long nextStatusPrintInNanos = null;
            while (this.threadActive) {
                boolean success;
                boolean bl = success = this.pathRoot.exists() && this.pathRoot.isDirectory() && this.pathRoot.canRead();
                if (success) {
                    watchSuccess = true;
                    break;
                }
                if (nextStatusPrintInNanos == null) {
                    nextStatusPrintInNanos = System.nanoTime() + TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
                } else if (System.nanoTime() > nextStatusPrintInNanos) {
                    nextStatusPrintInNanos = null;
                    this.log.logInfo("Waiting for " + this.pathRoot + " to exist, and be accessible.");
                }
                FilewatcherUtils.sleep((long)50L);
                if (System.nanoTime() <= expireTimeInNanos) continue;
                watchSuccess = false;
                break;
            }
            if (!this.threadActive) {
                return false;
            }
            if (watchSuccess) {
                try {
                    this.addDirectoryRecursive(this.pathRoot.toPath(), new ArrayList<File>());
                }
                catch (IOException e) {
                    this.log.logError("Unable to watch directory: " + this.pathRoot.getPath(), (Throwable)e);
                    watchSuccess = false;
                }
            }
            ArrayList listeners = new ArrayList();
            List list = this.parent.listeners_synch;
            synchronized (list) {
                listeners.addAll(this.parent.listeners_synch);
            }
            for (IPlatformWatchService.IPlatformWatchListener pw : listeners) {
                pw.watchAdded(this.projectToWatch, watchSuccess);
            }
            if (watchSuccess) {
                this.log.logInfo("Watch succeeded on " + this.pathRoot.getPath() + " for " + this.projectToWatch.getProjectId());
            } else {
                this.log.logError("Watch failed on " + this.pathRoot.getPath() + " for " + this.projectToWatch.getProjectId());
            }
            return watchSuccess;
        }

        public File getPathRoot() {
            return this.pathRoot;
        }
    }

    private static class WatchedPathThread
    extends Thread {
        private static final FWLogger log = FWLogger.getInstance();
        private final WatchedPath watchedPath;

        private WatchedPathThread(WatchedPath watchedPath) {
            this.watchedPath = watchedPath;
        }

        @Override
        public void run() {
            try {
                if (DEBUG) {
                    log.logDebug("Generic watch service thread for '" + this.watchedPath.pathRoot + "' started.");
                }
                this.watchedPath.eventLoopCatchAll();
            }
            catch (Throwable t) {
                log.logSevere("WatchPathThreadDied", t, null);
            }
            finally {
                if (DEBUG) {
                    log.logDebug("Generic watch service thread for '" + this.watchedPath.pathRoot + "' ended.");
                }
            }
        }
    }
}

