/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.module;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilderListener;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SdkSettingsStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.FileUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.core.connection.ProjectTemplateInfo;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.module.CodewindModuleType;
import org.eclipse.codewind.intellij.ui.module.CustomOptionsStep;
import org.eclipse.codewind.intellij.ui.module.NewCodewindProjectStep;
import org.eclipse.codewind.intellij.ui.module.SetupCodewindProjectRunnable;
import org.eclipse.codewind.intellij.ui.tree.CodewindToolWindowHelper;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class CodewindModuleBuilder
extends JavaModuleBuilder
implements ModuleBuilderListener {
    private ProjectTemplateInfo template;
    private boolean isSuccessful;
    private CodewindConnection connection;
    private NewCodewindProjectStep newCodewindProjectStep;

    public CodewindModuleBuilder() {
        this.addListener(this);
        this.newCodewindProjectStep = new NewCodewindProjectStep(this);
    }

    public CodewindModuleType getModuleType() {
        return CodewindModuleType.getInstance();
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new CustomOptionsStep();
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(0);
        }
        if (modulesProvider == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(1);
        }
        return new ModuleWizardStep[]{this.newCodewindProjectStep};
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(2);
        }
        String moduleFilePath = this.getModuleFilePath();
        CodewindModuleBuilder.deleteModuleFile((String)moduleFilePath);
        Module module = moduleModel.newModule(moduleFilePath, StdModuleTypes.JAVA.getId());
        this.setupModule(module);
        Module module2 = module;
        if (module2 == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(3);
        }
        return module2;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(4);
        }
        return new SdkSettingsStep(settingsStep, (ModuleBuilder)this, arg_0 -> ((CodewindModuleBuilder)this).isSuitableSdkType(arg_0));
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        if (modifiableRootModel == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(5);
        }
        modifiableRootModel.inheritSdk();
        super.setupRootModel(modifiableRootModel);
    }

    public void setSelectedTemplate(ProjectTemplateInfo template) {
        this.template = template;
    }

    public void moduleCreated(@NotNull Module module) {
        if (module == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(6);
        }
        Project ideaProject = module.getProject();
        CodewindToolWindowHelper.setInitialProjectToSelect(module.getProject());
        StartupManager.getInstance((Project)ideaProject).registerPostStartupActivity(() -> {
            Notification[] notificationsOfType;
            for (Notification n : notificationsOfType = NotificationsManager.getNotificationsManager().getNotificationsOfType(Notification.class, module.getProject())) {
                if ("Maven Import".equals(n.getGroupId())) {
                    n.expire();
                }
                if (!"Maven: non-managed pom.xml".equals(n.getGroupId())) continue;
                this.addAndImportProject(module.getProject());
            }
            CodewindToolWindowHelper.openCodewindWindow(module.getProject());
        });
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        if (project == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(7);
        }
        Module module = super.commitModule(project, model);
        try {
            module = this.postCommitModule(module);
            if (module != null) {
                this.addAndImportProject(module.getProject());
            }
        }
        catch (ProcessCanceledException e) {
            Messages.showErrorDialog((String)CodewindUIBundle.message("NewProjectSetupProcessCanceledMessage", new Object[0]), (String)CodewindUIBundle.message("NewProjectSetupProcessCanceledTitle", new Object[0]));
            throw e;
        }
        return module;
    }

    private Module postCommitModule(@NotNull Module module) throws ProcessCanceledException {
        String javaHome;
        if (module == null) {
            CodewindModuleBuilder.$$$reportNull$$$0(8);
        }
        String path = this.getModuleFileDirectory();
        String name = this.getName();
        String url = this.template.getUrl();
        String language = this.template.getLanguage();
        String projectType = this.template.getProjectType();
        String conid = this.connection != null ? this.connection.getConid() : "local";
        Project ideaProject = module.getProject();
        Sdk sdk = ProjectRootManager.getInstance((Project)ideaProject).getProjectSdk();
        String string = javaHome = sdk == null ? null : sdk.getHomePath();
        if (javaHome == null) {
            Logger.log("createProject: no sdk set for project: " + ideaProject.getName());
        }
        SetupCodewindProjectRunnable setupProjectRunnable = new SetupCodewindProjectRunnable(path, name, url, language, projectType, conid, javaHome);
        this.isSuccessful = ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)setupProjectRunnable, CodewindUIBundle.message("NewProjectWizard_ProgressTitle", new Object[0]), true, ideaProject);
        if (!this.isSuccessful) {
            throw new ProcessCanceledException();
        }
        return module;
    }

    private void addAndImportProject(Project project) {
        @SystemIndependent String basePath = project.getBasePath();
        if (basePath != null) {
            File pomXml = new File(basePath.concat(File.separator + "pom.xml"));
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)pomXml, (boolean)false);
            MavenProjectsManager manager = MavenProjectsManager.getInstance((Project)project);
            if (manager != null && virtualFile != null) {
                manager.addManagedFilesOrUnignore(Collections.singletonList(virtualFile));
                manager.scheduleImportAndResolve(false);
            }
        }
    }

    void onWizardFinished() throws CommitStepException {
        if (this.getName() == null) {
            return;
        }
        File projectFolder = new File(this.getModuleFileDirectory());
        File[] files = projectFolder.listFiles();
        if (files.length > 1 || files.length == 1 && !files[0].getName().equals(".idea")) {
            throw new CommitStepException(CodewindUIBundle.message("ProjectFolderNotEmpty", projectFolder));
        }
        List<CodewindApplication> applications = ConnectionManager.getManager().getLocalConnection().getApps();
        if (applications.stream().anyMatch(a -> a.getName().equals(this.getName()))) {
            throw new CommitStepException(CodewindUIBundle.message("NewProjectPage_ProjectExistsError", this.getName()));
        }
    }

    public void cleanup() {
        super.cleanup();
        if (!this.isSuccessful) {
            String moduleFileDirectory = this.getModuleFileDirectory();
            Logger.log("Cancel was pressed. Removing folder " + moduleFileDirectory);
            try {
                FileUtil.deleteDirectory(moduleFileDirectory, true);
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
    }

    public void setConnection(CodewindConnection connection) {
        this.connection = connection;
        this.newCodewindProjectStep.setConnection(connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/eclipse/codewind/intellij/ui/module/CodewindModuleBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/eclipse/codewind/intellij/ui/module/CodewindModuleBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modifyProjectTypeStep";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "moduleCreated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "commitModule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "postCommitModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

