/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.toolwindow;

import com.intellij.notification.Notification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.Enumeration;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.console.ILogChangeNotifier;
import org.eclipse.codewind.intellij.ui.IconCache;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;

public class LogsViewNotifier
implements ILogChangeNotifier {
    private static final String HTML_HREF = "href";
    private Project project;
    private String message = "";

    public LogsViewNotifier(Project project) {
        this.project = project;
    }

    @Override
    public synchronized void notifyChange(String displayName) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.project);
        Balloon logFilesWindowBalloon = toolWindowManager.getToolWindowBalloon("org.eclipse.codewind.intellij.ui.logFilesToolWindow");
        String htmlContent = CodewindUIBundle.message("LogFilesNotification", new Object[0]);
        if (logFilesWindowBalloon != null) {
            String originalMessage = this.message;
            if (this.message.contains(displayName)) {
                this.message = this.message.replace("<a href='" + displayName + "'>" + displayName + "</a>\n", "");
            }
            this.message = "<a href='" + displayName + "'>" + displayName + "</a>\n" + this.message;
            if (originalMessage.equals(this.message)) {
                return;
            }
        } else {
            this.message = "<a href='" + displayName + "'>" + displayName + "</a>\n";
        }
        htmlContent = htmlContent.concat(this.message);
        Notification notification = CoreUtil.getLogUpdatesNotification().createNotification();
        notification.setContent(htmlContent);
        notification.setIcon(IconCache.getCachedIcon("/icons/themeless/codewind.svg"));
        notification.setListener((aNotification, hyperlinkEvent) -> {
            HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
            if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
                Element sourceElement = hyperlinkEvent.getSourceElement();
                AttributeSet attributes = sourceElement.getAttributes();
                Enumeration<?> attributeNames = attributes.getAttributeNames();
                ContentManager contentManager = toolWindowManager.getToolWindow("org.eclipse.codewind.intellij.ui.logFilesToolWindow").getContentManager();
                ToolWindow logWindow = toolWindowManager.getToolWindow("org.eclipse.codewind.intellij.ui.logFilesToolWindow");
                while (attributeNames.hasMoreElements()) {
                    HTML.Attribute attr;
                    String attrString;
                    Object o = attributeNames.nextElement();
                    if (!(o instanceof HTML.Attribute) || !HTML_HREF.equals(attrString = (attr = (HTML.Attribute)o).toString())) continue;
                    Object attribute = attributes.getAttribute(attr);
                    String logFile = attribute.toString();
                    Content content = contentManager.findContent(logFile);
                    if (logWindow != null && !logWindow.isVisible() || !logWindow.isActive()) {
                        logWindow.show(null);
                    }
                    if (content == null) break;
                    contentManager.setSelectedContent(content);
                    break;
                }
            }
        });
        notification.notify(this.project);
    }
}

