/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.net.MalformedURLException;
import java.nio.file.Path;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.FileUtil;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.constants.ProjectCapabilities;
import org.eclipse.codewind.intellij.core.constants.ProjectLanguage;
import org.eclipse.codewind.intellij.core.constants.ProjectType;
import org.eclipse.codewind.intellij.core.launch.CoreUiUtil;
import org.jetbrains.annotations.SystemIndependent;

public class CodewindIntellijApplication
extends CodewindApplication {
    private RunnerAndConfigurationSettings runnerAndConfigurationSettings;

    CodewindIntellijApplication(CodewindConnection connection, String id, String name, ProjectType projectType, ProjectLanguage language, Path localPath) throws MalformedURLException {
        super(connection, id, name, projectType, language, localPath);
    }

    public synchronized void setRunnerAndConfigurationSettings(RunnerAndConfigurationSettings settings) {
        this.runnerAndConfigurationSettings = settings;
    }

    public boolean canInitiateDebugSession() {
        if (this.projectLanguage.isJava()) {
            return this.supportsDebug();
        }
        return false;
    }

    @Override
    public boolean supportsDebug() {
        if (this.projectLanguage == ProjectLanguage.LANGUAGE_JAVA || this.projectLanguage == ProjectLanguage.LANGUAGE_NODEJS) {
            ProjectCapabilities capabilities = this.getProjectCapabilities();
            return (capabilities.supportsDebugMode() || capabilities.supportsDebugNoInitMode()) && capabilities.canRestart();
        }
        return false;
    }

    @Override
    public void clearDebugger() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Project currentProject = null;
        for (Project project : openProjects) {
            @SystemIndependent String basePath = project.getBasePath();
            if (!FileUtil.isSamePath(this.fullLocalPath.toAbsolutePath().toString(), basePath)) continue;
            currentProject = project;
            break;
        }
        if (currentProject == null) {
            return;
        }
        CoreUiUtil.clearRunConfig(currentProject, this.runnerAndConfigurationSettings);
        this.runnerAndConfigurationSettings = null;
    }

    @Override
    public void connectDebugger() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Project currentProject = null;
        for (Project project : openProjects) {
            @SystemIndependent String basePath = project.getBasePath();
            if (!FileUtil.isSamePath(this.fullLocalPath.toAbsolutePath().toString(), basePath)) continue;
            currentProject = project;
            break;
        }
        if (currentProject == null) {
            return;
        }
        CoreUiUtil.debug(currentProject, this);
    }

    @Override
    public void reconnectDebugger() {
    }
}

