/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tasks;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.jetbrains.annotations.NotNull;

public class OpenIdeaProjectTask
extends Task.Backgroundable {
    private final CodewindApplication application;

    public OpenIdeaProjectTask(CodewindApplication application) {
        super(null, CodewindUIBundle.message("ProjectOpenJob", application.getName()));
        this.application = application;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            OpenIdeaProjectTask.$$$reportNull$$$0(0);
        }
        try {
            this.run0(indicator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void run0(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            OpenIdeaProjectTask.$$$reportNull$$$0(1);
        }
        ProjectManagerEx pm = ProjectManagerEx.getInstanceEx();
        Path path = this.application.ideaProjectPath();
        if (path == null) {
            System.out.println("*** creating idea project for: application" + this.application.getName());
            Files.createDirectory(this.application.fullLocalPath.resolve(".idea"), new FileAttribute[0]);
            String project = this.application.fullLocalPath.toString();
            CoreUtil.invokeLater(() -> ProjectUtil.openOrImport((String)project, null, (boolean)false));
            return;
        }
        System.out.println("*** loading idea project for: application" + this.application.getName());
        Project project = pm.loadProject(path);
        if (project == null) {
            System.out.println("*** no project returned for application " + this.application.getName());
        } else if (!project.isOpen()) {
            Runnable runner = () -> pm.openProject(project);
            TransactionGuard.getInstance().submitTransactionAndWait(runner);
        }
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error == null) {
            OpenIdeaProjectTask.$$$reportNull$$$0(2);
        }
        Throwable t = error;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        Logger.logWarning("An error occurred opening project " + this.application.getName(), t);
        Messages.showErrorDialog((String)CodewindUIBundle.message("ProjectOpenError", this.application.getName()), (String)"Codewind");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/tasks/OpenIdeaProjectTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "run0";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onThrowable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

