/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tasks;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.jetbrains.annotations.NotNull;

public class AutoBuildTask
extends Task.Backgroundable {
    private final CodewindApplication application;
    private final boolean enable;

    public AutoBuildTask(CodewindApplication application, boolean enable) {
        super(null, CodewindUIBundle.message("EnableDisableAutoBuildJob", application.name));
        this.application = application;
        this.enable = enable;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            AutoBuildTask.$$$reportNull$$$0(0);
        }
        try {
            String actionKey = this.enable ? "enableautobuild" : "disableautobuild";
            this.application.connection.requestProjectBuild(this.application, actionKey);
            this.application.setAutoBuild(this.enable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error == null) {
            AutoBuildTask.$$$reportNull$$$0(1);
        }
        Throwable t = error;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        Logger.logWarning("An error occurred changing auto build setting for: " + this.application.name + ", with id: " + this.application.projectID, t);
        Messages.showErrorDialog((String)CodewindUIBundle.message("ErrorOnEnableDisableAutoBuild", this.application.name, t.getLocalizedMessage()), (String)"Codewind");
    }

    public static AutoBuildTask createEnabler(CodewindApplication application) {
        return new AutoBuildTask(application, true);
    }

    public static AutoBuildTask createDisabler(CodewindApplication application) {
        return new AutoBuildTask(application, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/tasks/AutoBuildTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onThrowable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

